/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.projectile;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDungeonEye;
import com.lothrazar.cyclicmagic.item.projectile.BaseItemProjectile;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilInventory;
import com.lothrazar.cyclicmagic.util.UtilSearchWorld;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemProjectileDungeon
extends BaseItemProjectile
implements IHasRecipe,
IHasConfig {
    private static int DUNGEONRADIUS = 64;

    @Override
    public void syncConfig(Configuration config) {
        DUNGEONRADIUS = config.getInt("Ender Dungeon Radius", "cyclicmagic.items", 64, 8, 128, "Search radius of dungeonfinder");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this, 6), (Object[])new Object[]{new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150341_Y), new ItemStack(Items.field_151075_bm)});
    }

    @Override
    void onItemThrow(ItemStack held, World world, EntityPlayer player, EnumHand hand) {
        BlockPos blockpos = UtilSearchWorld.findClosestBlock(player, Blocks.field_150474_ac, DUNGEONRADIUS);
        if (blockpos != null) {
            EntityDungeonEye entityendereye = new EntityDungeonEye(world, (EntityLivingBase)player);
            this.doThrow(world, player, hand, entityendereye);
            entityendereye.moveTowards(blockpos);
        } else {
            BlockPos pos = player.func_180425_c();
            UtilInventory.decrStackSize(player, player.field_71071_by.field_70461_c);
            UtilEntity.dropItemStackInWorld(world, pos, new ItemStack((Item)this));
            UtilSound.playSound(player, pos, SoundEvents.field_187646_bt);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

