/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.registry.SpellRegistry;
import com.lothrazar.cyclicmagic.spell.ISpell;
import com.lothrazar.cyclicmagic.spell.ISpellFromServer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSpellFromServer
implements IMessage,
IMessageHandler<PacketSpellFromServer, IMessage> {
    public static final int ID = 16;
    private BlockPos pos;
    private BlockPos posOffset;
    private int spellID;

    public PacketSpellFromServer() {
    }

    public PacketSpellFromServer(BlockPos mouseover, BlockPos offset, int spellid) {
        this.pos = mouseover;
        this.posOffset = offset;
        this.spellID = spellid;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        x = tags.func_74762_e("ox");
        y = tags.func_74762_e("oy");
        z = tags.func_74762_e("oz");
        this.posOffset = new BlockPos(x, y, z);
        this.spellID = tags.func_74762_e("spell");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("ox", this.posOffset.func_177958_n());
        tags.func_74768_a("oy", this.posOffset.func_177956_o());
        tags.func_74768_a("oz", this.posOffset.func_177952_p());
        tags.func_74768_a("spell", this.spellID);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketSpellFromServer message, MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            ISpell spell = SpellRegistry.getSpellFromID(message.spellID);
            if (spell != null && spell instanceof ISpellFromServer) {
                ((ISpellFromServer)((Object)spell)).castFromServer(message.pos, message.posOffset, (EntityPlayer)p);
            } else {
                ModMain.logger.warn("WARNING: Message from server: spell not found" + message.spellID);
            }
        }
        return null;
    }
}

