/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.proxy;

import com.lothrazar.cyclicmagic.entity.projectile.EntityBlazeBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDungeonEye;
import com.lothrazar.cyclicmagic.entity.projectile.EntityDynamite;
import com.lothrazar.cyclicmagic.entity.projectile.EntityFishingBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityHarvestBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityLightningballBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityShearingBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntitySnowballBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityTorchBolt;
import com.lothrazar.cyclicmagic.entity.projectile.EntityWaterBolt;
import com.lothrazar.cyclicmagic.proxy.CommonProxy;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.KeyInventoryShiftRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientProxy
extends CommonProxy {
    public static KeyBinding keyShiftUp;
    public static KeyBinding keyShiftDown;
    public static KeyBinding keyBarUp;
    public static KeyBinding keyBarDown;
    static final String keyCategoryInventory = "key.categories.inventorycontrol";

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void register() {
        this.registerModels();
        this.registerKeys();
        this.registerEntities();
    }

    private void registerKeys() {
        if (KeyInventoryShiftRegistry.enableInvoKeys) {
            keyShiftUp = new KeyBinding("key.columnshiftup", 21, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyShiftUp);
            keyShiftDown = new KeyBinding("key.columnshiftdown", 35, keyCategoryInventory);
            ClientRegistry.registerKeyBinding((KeyBinding)keyShiftDown);
            keyBarUp = new KeyBinding("key.columnbarup", 21, keyCategoryInventory);
            keyBarUp.setKeyModifierAndCode(KeyModifier.SHIFT, 21);
            ClientRegistry.registerKeyBinding((KeyBinding)keyBarUp);
            keyBarDown = new KeyBinding("key.columnbardown", 35, keyCategoryInventory);
            keyBarDown.setKeyModifierAndCode(KeyModifier.SHIFT, 35);
            ClientRegistry.registerKeyBinding((KeyBinding)keyBarDown);
        }
    }

    private void registerEntities() {
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningballBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_lightning"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityHarvestBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_harvest"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityWaterBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_water"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntitySnowballBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_snow"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityTorchBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_torch"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityFishingBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_fishing"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityShearingBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_wool"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityDungeonEye.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_dungeon"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_tnt_1"), ri));
        RenderingRegistry.registerEntityRenderingHandler(EntityBlazeBolt.class, (Render)new RenderSnowball(rm, ItemRegistry.itemMap.get("ender_blaze"), ri));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumFacing getSideMouseover(int max) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null) {
            return mouseOver.field_178784_b;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverExact(int max) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null) {
            return mouseOver.func_178782_a();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockPos getBlockMouseoverOffset(int max) {
        BlockPos blockPos;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        RayTraceResult mouseOver = Minecraft.func_71410_x().func_175606_aa().func_174822_a((double)max, 1.0f);
        if (mouseOver != null && mouseOver.field_178784_b != null && (blockPos = mouseOver.func_178782_a()) != null && player.field_70170_p.func_180495_p(blockPos) != null && !player.field_70170_p.func_175623_d(blockPos)) {
            return blockPos.func_177972_a(mouseOver.field_178784_b);
        }
        return null;
    }

    private void registerModels() {
        String name;
        Item item;
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (Block b : BlockRegistry.blocks) {
            item = Item.func_150898_a((Block)b);
            name = "cyclicmagic:" + b.func_149739_a().replaceAll("tile.", "");
            mesher.func_178086_a(item, 0, new ModelResourceLocation(name, "inventory"));
        }
        for (String key : ItemRegistry.itemMap.keySet()) {
            item = ItemRegistry.itemMap.get(key);
            name = "cyclicmagic:" + item.func_77658_a().replaceAll("item.", "");
            mesher.func_178086_a(item, 0, new ModelResourceLocation(name, "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setClientPlayerData(MessageContext ctx, NBTTagCompound tags) {
        CapabilityRegistry.IPlayerExtendedProperties props;
        EntityPlayer p = this.getPlayerEntity(ctx);
        if (p != null && (props = CapabilityRegistry.getPlayerProperties((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) != null) {
            props.setDataFromNBT(tags);
        }
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(ctx);
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }
}

