/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.block.BlockBucketStorage;
import com.lothrazar.cyclicmagic.block.BlockBuilder;
import com.lothrazar.cyclicmagic.block.BlockConveyor;
import com.lothrazar.cyclicmagic.block.BlockDimensionOre;
import com.lothrazar.cyclicmagic.block.BlockLaunch;
import com.lothrazar.cyclicmagic.block.BlockScaffolding;
import com.lothrazar.cyclicmagic.block.BlockSprout;
import com.lothrazar.cyclicmagic.block.BlockUncrafting;
import com.lothrazar.cyclicmagic.item.ItemSproutSeeds;
import com.lothrazar.cyclicmagic.item.itemblock.ItemBlockBucket;
import com.lothrazar.cyclicmagic.item.itemblock.ItemBlockScaffolding;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockRegistry {
    public static ArrayList<Block> blocks = new ArrayList();
    public static BlockScaffolding block_fragile;
    static BlockUncrafting uncrafting_block;
    public static BlockBucketStorage block_storelava;
    public static BlockBucketStorage block_storewater;
    public static BlockBucketStorage block_storemilk;
    public static BlockBucketStorage block_storeempty;
    public static BlockDimensionOre nether_gold_ore;
    public static BlockDimensionOre nether_coal_ore;
    public static BlockDimensionOre nether_lapis_ore;
    public static BlockDimensionOre nether_emerald_ore;
    public static BlockDimensionOre end_redstone_ore;
    public static BlockDimensionOre end_coal_ore;
    public static BlockDimensionOre end_lapis_ore;
    public static BlockDimensionOre end_emerald_ore;
    public static BlockDimensionOre nether_diamond_ore;
    public static BlockDimensionOre end_diamond_ore;
    private static boolean spawnersUnbreakable;
    private static BlockBuilder builder_block;

    private static void registerBlock(Block b, String name) {
        BlockRegistry.registerBlock(b, name, false);
    }

    private static void registerBlock(Block b, String name, boolean isHidden) {
        BlockRegistry.registerBlock(b, new ItemBlock(b), name, isHidden);
    }

    private static void registerBlock(Block b, ItemBlock ib, String name) {
        BlockRegistry.registerBlock(b, ib, name, false);
    }

    private static void registerBlock(Block b, ItemBlock ib, String name, boolean isHidden) {
        b.setRegistryName(name);
        b.func_149663_c(name);
        GameRegistry.register((IForgeRegistryEntry)b);
        ib.setRegistryName(b.getRegistryName());
        GameRegistry.register((IForgeRegistryEntry)ib);
        if (!isHidden) {
            b.func_149647_a(ModMain.TAB);
        }
        blocks.add(b);
    }

    public static void register() {
        if (spawnersUnbreakable) {
            Blocks.field_150474_ac.func_149722_s();
        }
        BlockConveyor plate_push = new BlockConveyor(0.16f, SoundEvents.field_187677_b);
        BlockRegistry.registerBlock((Block)plate_push, "plate_push");
        plate_push.addRecipe();
        BlockRegistry.registerBlock(uncrafting_block, "uncrafting_block");
        uncrafting_block.addRecipe();
        BlockRegistry.registerBlock(builder_block, "builder_block");
        builder_block.addRecipe();
        BlockRegistry.registerBlock((Block)block_fragile, new ItemBlockScaffolding(block_fragile), "block_fragile");
        block_fragile.addRecipe();
        BlockRegistry.registerSprout();
        BlockRegistry.registerSlimePads();
        BlockRegistry.registerDimensionOres();
        BlockRegistry.registerBucketBlocks();
    }

    private static void registerBucketBlocks() {
        block_storewater = new BlockBucketStorage(Items.field_151131_as);
        BlockRegistry.registerBlock(block_storewater, new ItemBlockBucket(block_storewater), "block_storewater", true);
        block_storemilk = new BlockBucketStorage(Items.field_151117_aB);
        BlockRegistry.registerBlock(block_storemilk, new ItemBlockBucket(block_storemilk), "block_storemilk", true);
        block_storelava = new BlockBucketStorage(Items.field_151129_at);
        BlockRegistry.registerBlock(block_storelava, new ItemBlockBucket(block_storelava), "block_storelava", true);
        block_storeempty = new BlockBucketStorage(null);
        BlockRegistry.registerBlock(block_storeempty, new ItemBlockBucket(block_storeempty), "block_storeempty", false);
        block_storeempty.addRecipe();
    }

    private static void registerDimensionOres() {
        nether_gold_ore = new BlockDimensionOre(Items.field_151074_bl, 0, 4);
        nether_gold_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 1);
        BlockRegistry.registerBlock((Block)nether_gold_ore, "nether_gold_ore");
        nether_coal_ore = new BlockDimensionOre(Items.field_151044_h);
        nether_coal_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 1);
        BlockRegistry.registerBlock((Block)nether_coal_ore, "nether_coal_ore");
        nether_lapis_ore = new BlockDimensionOre(Items.field_151100_aR, EnumDyeColor.BLUE.func_176767_b(), 3);
        nether_lapis_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 2);
        BlockRegistry.registerBlock((Block)nether_lapis_ore, "nether_lapis_ore");
        nether_emerald_ore = new BlockDimensionOre(Items.field_151166_bC);
        nether_emerald_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 5);
        BlockRegistry.registerBlock((Block)nether_emerald_ore, "nether_emerald_ore");
        nether_diamond_ore = new BlockDimensionOre(Items.field_151045_i);
        nether_diamond_ore.setSpawnType(BlockDimensionOre.SpawnType.SILVERFISH, 8);
        BlockRegistry.registerBlock((Block)nether_diamond_ore, "nether_diamond_ore");
        end_redstone_ore = new BlockDimensionOre(Items.field_151137_ax);
        end_redstone_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 3);
        BlockRegistry.registerBlock((Block)end_redstone_ore, "end_redstone_ore");
        end_coal_ore = new BlockDimensionOre(Items.field_151044_h);
        end_coal_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 1);
        BlockRegistry.registerBlock((Block)end_coal_ore, "end_coal_ore");
        end_lapis_ore = new BlockDimensionOre(Items.field_151100_aR, EnumDyeColor.BLUE.func_176767_b(), 3);
        end_lapis_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 5);
        BlockRegistry.registerBlock((Block)end_lapis_ore, "end_lapis_ore");
        end_emerald_ore = new BlockDimensionOre(Items.field_151166_bC);
        end_emerald_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 8);
        BlockRegistry.registerBlock((Block)end_emerald_ore, "end_emerald_ore");
        end_diamond_ore = new BlockDimensionOre(Items.field_151045_i);
        end_diamond_ore.setSpawnType(BlockDimensionOre.SpawnType.ENDERMITE, 8);
        BlockRegistry.registerBlock((Block)end_diamond_ore, "end_diamond_ore");
    }

    private static void registerSlimePads() {
        BlockLaunch plate_launch_small = new BlockLaunch(0.8f, SoundEvents.field_187888_ft);
        BlockLaunch plate_launch_med = new BlockLaunch(1.3f, SoundEvents.field_187876_fn);
        BlockLaunch plate_launch_large = new BlockLaunch(1.8f, SoundEvents.field_187872_fl);
        BlockRegistry.registerBlock((Block)plate_launch_small, "plate_launch_small");
        BlockRegistry.registerBlock((Block)plate_launch_med, "plate_launch_med");
        BlockRegistry.registerBlock((Block)plate_launch_large, "plate_launch_large");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)plate_launch_small, 6), (Object[])new Object[]{"sss", "ggg", "iii", Character.valueOf('s'), Blocks.field_180399_cE, Character.valueOf('g'), Blocks.field_150445_bS, Character.valueOf('i'), Blocks.field_150443_bT});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)plate_launch_med), (Object[])new Object[]{new ItemStack((Block)plate_launch_small), new ItemStack(Items.field_151128_bU)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)plate_launch_large), (Object[])new Object[]{new ItemStack((Block)plate_launch_med), new ItemStack(Blocks.field_150377_bs)});
    }

    private static void registerSprout() {
        BlockSprout sprout = new BlockSprout();
        BlockRegistry.registerBlock((Block)sprout, "sprout", true);
        ItemRegistry.sprout_seed = new ItemSproutSeeds((Block)sprout, Blocks.field_150458_ak);
        ItemRegistry.sprout_seed.func_77655_b("sprout_seed");
        ItemRegistry.registerItem((Item)ItemRegistry.sprout_seed, "sprout_seed");
        ItemRegistry.itemMap.put("sprout_seed", (Item)ItemRegistry.sprout_seed);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ItemRegistry.sprout_seed, 8, 0), (Object[])new Object[]{"waw", "bEc", "wdw", Character.valueOf('w'), Items.field_151014_N, Character.valueOf('E'), Items.field_151166_bC, Character.valueOf('a'), Items.field_185163_cU, Character.valueOf('b'), Items.field_151081_bc, Character.valueOf('c'), Items.field_151080_bb, Character.valueOf('d'), Items.field_151075_bm});
    }

    public static void construct() {
        uncrafting_block = new BlockUncrafting();
        builder_block = new BlockBuilder();
        block_fragile = new BlockScaffolding();
    }

    public static void syncConfig(Configuration config) {
        String category = "cyclicmagic.blocks";
        spawnersUnbreakable = config.getBoolean("Spawners Unbreakable", category, true, "Make mob spawners unbreakable");
        uncrafting_block.syncConfig(config);
        builder_block.syncConfig(config);
    }
}

