/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.net.PacketSyncPlayerData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityRegistry {
    public static void register() {
        CapabilityManager.INSTANCE.register(IPlayerExtendedProperties.class, (Capability.IStorage)new Storage(), InstancePlayerExtendedProperties.class);
    }

    public static IPlayerExtendedProperties getPlayerProperties(EntityPlayer player) {
        return (IPlayerExtendedProperties)player.getCapability(ModMain.CAPABILITYSTORAGE, null);
    }

    public static void syncServerDataToClient(EntityPlayerMP p) {
        if (p == null) {
            return;
        }
        IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties((EntityPlayer)p);
        if (props != null) {
            ModMain.network.sendTo((IMessage)new PacketSyncPlayerData(props.getDataAsNBT()), p);
        }
    }

    public static class Storage
    implements Capability.IStorage<IPlayerExtendedProperties> {
        public NBTTagCompound writeNBT(Capability<IPlayerExtendedProperties> capability, IPlayerExtendedProperties instance, EnumFacing side) {
            return instance.getDataAsNBT();
        }

        public void readNBT(Capability<IPlayerExtendedProperties> capability, IPlayerExtendedProperties instance, EnumFacing side, NBTBase nbt) {
            try {
                instance.setDataFromNBT((NBTTagCompound)nbt);
            }
            catch (Exception e) {
                ModMain.logger.error("Invalid NBT compound: " + e.getMessage());
                ModMain.logger.error(e.getStackTrace().toString());
            }
        }
    }

    public static class InstancePlayerExtendedProperties
    implements IPlayerExtendedProperties {
        private boolean isSleeping = false;
        private boolean hasInventoryCrafting = false;
        private boolean hasInventoryExtended = false;
        private String todo = "";
        private int health = 20;

        @Override
        public boolean isSleeping() {
            return this.isSleeping;
        }

        @Override
        public void setSleeping(boolean value) {
            this.isSleeping = value;
        }

        @Override
        public boolean hasInventoryCrafting() {
            return this.hasInventoryCrafting;
        }

        @Override
        public void setInventoryCrafting(boolean value) {
            this.hasInventoryCrafting = value;
        }

        @Override
        public boolean hasInventoryExtended() {
            return this.hasInventoryExtended;
        }

        @Override
        public void setInventoryExtended(boolean value) {
            this.hasInventoryExtended = value;
        }

        @Override
        public NBTTagCompound getDataAsNBT() {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74774_a("isSleeping", (byte)(this.isSleeping() ? 1 : 0));
            tags.func_74774_a("hasInventoryCrafting", (byte)(this.hasInventoryCrafting() ? 1 : 0));
            tags.func_74774_a("hasInventoryExtended", (byte)(this.hasInventoryExtended() ? 1 : 0));
            tags.func_74778_a("todo", this.getTODO());
            tags.func_74768_a("mhealth", this.getMaxHealth());
            return tags;
        }

        @Override
        public void setDataFromNBT(NBTTagCompound nbt) {
            NBTTagCompound tags = !(nbt instanceof NBTTagCompound) ? new NBTTagCompound() : nbt;
            this.setSleeping(tags.func_74771_c("isSleeping") == 1);
            this.setInventoryCrafting(tags.func_74771_c("hasInventoryCrafting") == 1);
            this.setInventoryExtended(tags.func_74771_c("hasInventoryExtended") == 1);
            this.setTODO(tags.func_74779_i("todo"));
            this.setMaxHealth(tags.func_74762_e("mhealth"));
        }

        @Override
        public String getTODO() {
            return this.todo;
        }

        @Override
        public void setTODO(String value) {
            this.todo = value;
        }

        @Override
        public int getMaxHealth() {
            return this.health;
        }

        @Override
        public void setMaxHealth(int value) {
            this.health = value;
        }
    }

    public static interface IPlayerExtendedProperties {
        public boolean isSleeping();

        public void setSleeping(boolean var1);

        public boolean hasInventoryCrafting();

        public void setInventoryCrafting(boolean var1);

        public boolean hasInventoryExtended();

        public void setInventoryExtended(boolean var1);

        public int getMaxHealth();

        public void setMaxHealth(int var1);

        public NBTTagCompound getDataAsNBT();

        public void setDataFromNBT(NBTTagCompound var1);

        public String getTODO();

        public void setTODO(String var1);
    }
}

