/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.command.CommandEnderChest;
import com.lothrazar.cyclicmagic.command.CommandGetHome;
import com.lothrazar.cyclicmagic.command.CommandHeal;
import com.lothrazar.cyclicmagic.command.CommandHearts;
import com.lothrazar.cyclicmagic.command.CommandHome;
import com.lothrazar.cyclicmagic.command.CommandPing;
import com.lothrazar.cyclicmagic.command.CommandRecipe;
import com.lothrazar.cyclicmagic.command.CommandSearchItem;
import com.lothrazar.cyclicmagic.command.CommandSearchSpawner;
import com.lothrazar.cyclicmagic.command.CommandSearchTrades;
import com.lothrazar.cyclicmagic.command.CommandTodoList;
import com.lothrazar.cyclicmagic.command.CommandUses;
import com.lothrazar.cyclicmagic.command.CommandVillageInfo;
import com.lothrazar.cyclicmagic.command.CommandWorldHome;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class CommandRegistry {
    private static Map<String, Boolean> configToggle = new HashMap<String, Boolean>();
    private static Map<String, Boolean> commandNeedsOp = new HashMap<String, Boolean>();
    private static String category;

    public static void register(FMLServerStartingEvent event) {
        if (configToggle.get("enderchest").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandEnderChest(commandNeedsOp.get("enderchest")));
        }
        if (configToggle.get("gethome").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandGetHome(commandNeedsOp.get("gethome")));
        }
        if (configToggle.get("heal").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandHeal(commandNeedsOp.get("heal")));
        }
        if (configToggle.get("sethearts").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandHearts(commandNeedsOp.get("sethearts")));
        }
        if (configToggle.get("home").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandHome(commandNeedsOp.get("home")));
        }
        if (configToggle.get("ping").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandPing(commandNeedsOp.get("ping")));
        }
        if (configToggle.get("searchrecipe").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandRecipe(commandNeedsOp.get("searchrecipe")));
        }
        if (configToggle.get("searchitem").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandSearchItem(commandNeedsOp.get("searchitem")));
        }
        if (configToggle.get("searchspawner").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandSearchSpawner(commandNeedsOp.get("searchspawner")));
        }
        if (configToggle.get("searchtrade").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandSearchTrades(commandNeedsOp.get("searchtrade")));
        }
        if (configToggle.get("todo").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandTodoList(commandNeedsOp.get("todo")));
        }
        if (configToggle.get("searchuses").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandUses(commandNeedsOp.get("searchuses")));
        }
        if (configToggle.get("villageinfo").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandVillageInfo(commandNeedsOp.get("villageinfo")));
        }
        if (configToggle.get("worldhome").booleanValue()) {
            event.registerServerCommand((ICommand)new CommandWorldHome(commandNeedsOp.get("worldhome")));
        }
    }

    private static void syncCommandConfig(Configuration config, String name, boolean defaultNeedsOp, String comment) {
        Property prop = config.get(category, name, true, comment);
        prop.setRequiresMcRestart(true);
        configToggle.put(name, prop.getBoolean());
        prop = config.get(category, name + ".NeedsOP", defaultNeedsOp, "If true, only server OPs can run this command (or cheats enabled in single player)");
        prop.setRequiresMcRestart(true);
        commandNeedsOp.put(name, prop.getBoolean());
    }

    public static void syncConfig(Configuration config) {
        category = "modpacks.Commands";
        config.setCategoryComment(category, "Disable any command that was added");
        CommandRegistry.syncCommandConfig(config, "enderchest", true, "Opens your ender chest");
        CommandRegistry.syncCommandConfig(config, "gethome", false, "Get where your current spawn is set (by a bed)");
        CommandRegistry.syncCommandConfig(config, "heal", true, "Heal yourself (or a target player) to full");
        CommandRegistry.syncCommandConfig(config, "sethearts", true, "Increase the maximum hearts of a target player (lasts until death)");
        CommandRegistry.syncCommandConfig(config, "home", false, "Teleport you to your current spawn (if its set)");
        CommandRegistry.syncCommandConfig(config, "ping", false, "Display your current coordinates");
        CommandRegistry.syncCommandConfig(config, "searchrecipe", false, "Find recipes for an item");
        CommandRegistry.syncCommandConfig(config, "searchitem", false, "Search for an item in nearby containers");
        CommandRegistry.syncCommandConfig(config, "searchspawner", true, "Search the world nearby for spawners (dungeons, etc)");
        CommandRegistry.syncCommandConfig(config, "searchtrade", false, "Search nearby villagers for trades based on item names");
        CommandRegistry.syncCommandConfig(config, "todo", false, "Set reminders on screen for yourself");
        CommandRegistry.syncCommandConfig(config, "searchuses", false, "Find how an item is used in other recipes");
        CommandRegistry.syncCommandConfig(config, "villageinfo", false, "Get the stats on the nearest village (if any)");
        CommandRegistry.syncCommandConfig(config, "worldhome", false, "Teleport to true worldspawn");
    }
}

