/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.item.ItemAppleEmerald;
import com.lothrazar.cyclicmagic.item.ItemChestSack;
import com.lothrazar.cyclicmagic.item.ItemChestSackEmpty;
import com.lothrazar.cyclicmagic.item.ItemCyclicWand;
import com.lothrazar.cyclicmagic.item.ItemEmeraldArmor;
import com.lothrazar.cyclicmagic.item.ItemEmeraldAxe;
import com.lothrazar.cyclicmagic.item.ItemEmeraldHoe;
import com.lothrazar.cyclicmagic.item.ItemEmeraldPickaxe;
import com.lothrazar.cyclicmagic.item.ItemEmeraldSpade;
import com.lothrazar.cyclicmagic.item.ItemEmeraldSword;
import com.lothrazar.cyclicmagic.item.ItemEnderBook;
import com.lothrazar.cyclicmagic.item.ItemFoodCorruptedChorus;
import com.lothrazar.cyclicmagic.item.ItemFoodCrafting;
import com.lothrazar.cyclicmagic.item.ItemFoodHeart;
import com.lothrazar.cyclicmagic.item.ItemFoodHorse;
import com.lothrazar.cyclicmagic.item.ItemFoodInventory;
import com.lothrazar.cyclicmagic.item.ItemInventoryStorage;
import com.lothrazar.cyclicmagic.item.ItemPaperCarbon;
import com.lothrazar.cyclicmagic.item.ItemPotionCustom;
import com.lothrazar.cyclicmagic.item.ItemSleepingBag;
import com.lothrazar.cyclicmagic.item.ItemSproutSeeds;
import com.lothrazar.cyclicmagic.item.ItemToolHarvest;
import com.lothrazar.cyclicmagic.item.ItemToolPearlReuse;
import com.lothrazar.cyclicmagic.item.ItemToolPush;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileBlaze;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileDungeon;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileFishing;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileLightning;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileSnow;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileTNT;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileTorch;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileWater;
import com.lothrazar.cyclicmagic.item.projectile.ItemProjectileWool;
import com.lothrazar.cyclicmagic.registry.PotionRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemRegistry {
    public static Map<String, Item> itemMap = new HashMap<String, Item>();
    public static final ItemFoodCorruptedChorus corrupted_chorus = new ItemFoodCorruptedChorus();
    public static final ItemCyclicWand cyclic_wand_build = new ItemCyclicWand();
    public static final ItemPotionCustom potion_viscous = new ItemPotionCustom(false);
    public static final ItemPotionCustom potion_levitation = new ItemPotionCustom(true, MobEffects.field_188424_y, 180);
    public static final ItemPotionCustom potion_levitation_long = new ItemPotionCustom(true, MobEffects.field_188425_z, 480);
    public static final ItemPotionCustom potion_luck = new ItemPotionCustom(true, MobEffects.field_188425_z, 180);
    public static final ItemPotionCustom potion_luck_long = new ItemPotionCustom(true, MobEffects.field_188424_y, 480);
    public static final ItemPotionCustom potion_ender = new ItemPotionCustom(true);
    public static final ItemPotionCustom potion_ender_long = new ItemPotionCustom(true);
    public static final ItemPotionCustom potion_magnet = new ItemPotionCustom(false);
    public static final ItemPotionCustom potion_magnet_long = new ItemPotionCustom(false);
    public static final ItemPotionCustom potion_waterwalk = new ItemPotionCustom(false);
    public static final ItemPotionCustom potion_waterwalk_long = new ItemPotionCustom(false);
    public static final ItemPotionCustom potion_slowfall = new ItemPotionCustom(true);
    public static final ItemPotionCustom potion_slowfall_long = new ItemPotionCustom(true);
    public static final ItemPotionCustom potion_resistance = new ItemPotionCustom(true, MobEffects.field_76429_m, 180);
    public static final ItemPotionCustom potion_resistance_strong = new ItemPotionCustom(true, MobEffects.field_76429_m, 90, 1);
    public static final ItemPotionCustom potion_resistance_long = new ItemPotionCustom(true, MobEffects.field_76429_m, 480);
    public static final ItemPotionCustom potion_boost = new ItemPotionCustom(true, MobEffects.field_180152_w, 180, 4);
    public static final ItemPotionCustom potion_boost_long = new ItemPotionCustom(true, MobEffects.field_180152_w, 480, 4);
    public static final ItemPotionCustom potion_haste = new ItemPotionCustom(false, MobEffects.field_76422_e, 180);
    public static final ItemPotionCustom potion_haste_strong = new ItemPotionCustom(false, MobEffects.field_76422_e, 90, 1);
    public static final ItemPotionCustom potion_haste_long = new ItemPotionCustom(false, MobEffects.field_76422_e, 480);
    public static final ItemFoodHeart heart_food = new ItemFoodHeart();
    public static final ItemProjectileTNT ender_tnt_1 = new ItemProjectileTNT(1);
    public static final ItemProjectileTNT ender_tnt_2 = new ItemProjectileTNT(2);
    public static final ItemProjectileTNT ender_tnt_3 = new ItemProjectileTNT(3);
    public static final ItemProjectileTNT ender_tnt_4 = new ItemProjectileTNT(4);
    public static final ItemProjectileTNT ender_tnt_5 = new ItemProjectileTNT(5);
    public static final ItemProjectileTNT ender_tnt_6 = new ItemProjectileTNT(6);
    public static ItemEmeraldArmor emerald_boots;
    public static final Item tool_push;
    public static Item.ToolMaterial TOOL_MATERIAL_EMERALD;
    public static ItemArmor.ArmorMaterial ARMOR_MATERIAL_EMERALD;
    public static ItemSproutSeeds sprout_seed;
    public static final Item REPAIR_EMERALD;
    private static final int maxDamageFactorDiamond = 33;
    private static final String emeraldName = "emerald";

    public static void construct() {
        ItemRegistry.addItem(new ItemToolPearlReuse(), "ender_pearl_reuse");
        ItemRegistry.addItem(new ItemPaperCarbon(), "carbon_paper");
        ItemRegistry.addItem(new ItemToolHarvest(ItemToolHarvest.HarvestType.WEEDS), "tool_harvest_weeds");
        ItemRegistry.addItem(new ItemToolHarvest(ItemToolHarvest.HarvestType.CROPS), "tool_harvest_crops");
        ItemRegistry.addItem(new ItemToolHarvest(ItemToolHarvest.HarvestType.LEAVES), "tool_harvest_leaves");
        ItemRegistry.addItem(tool_push, "tool_push");
        ItemRegistry.addItem(new ItemInventoryStorage(), "storage_bag");
        ItemRegistry.addItem(new ItemChestSack().setHidden(), "chest_sack");
        ItemRegistry.addItem(new ItemChestSackEmpty(), "chest_sack_empty");
        ItemRegistry.addItem(new ItemProjectileBlaze(), "ender_blaze");
        ItemRegistry.addItem(new ItemProjectileDungeon(), "ender_dungeon");
        ItemRegistry.addItem(new ItemProjectileFishing(), "ender_fishing");
        ItemRegistry.addItem(new ItemProjectileWool(), "ender_wool");
        ItemRegistry.addItem(new ItemProjectileTorch(), "ender_torch");
        ItemRegistry.addItem(new ItemProjectileWater(), "ender_water");
        ItemRegistry.addItem(new ItemProjectileSnow(), "ender_snow");
        ItemRegistry.addItem(new ItemProjectileLightning(), "ender_lightning");
        ItemRegistry.addItem(ender_tnt_1, "ender_tnt_1");
        ItemRegistry.addItem(ender_tnt_2, "ender_tnt_2");
        ItemRegistry.addItem(ender_tnt_3, "ender_tnt_3");
        ItemRegistry.addItem(ender_tnt_4, "ender_tnt_4");
        ItemRegistry.addItem(ender_tnt_5, "ender_tnt_5");
        ItemRegistry.addItem(ender_tnt_6, "ender_tnt_6");
        ItemRegistry.addItem(new ItemFoodHorse(new ItemStack(Items.field_151166_bC)), "horse_upgrade_type");
        ItemRegistry.addItem(new ItemFoodHorse(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b())), "horse_upgrade_variant");
        ItemRegistry.addItem(new ItemFoodHorse(new ItemStack(Items.field_151045_i)), "horse_upgrade_health");
        ItemRegistry.addItem(new ItemFoodHorse(new ItemStack(Items.field_151137_ax)), "horse_upgrade_speed");
        ItemRegistry.addItem(new ItemFoodHorse(new ItemStack(Items.field_151061_bv)), "horse_upgrade_jump");
        ItemRegistry.addItem(new ItemEnderBook(), "book_ender");
        ItemRegistry.addItem((Item)corrupted_chorus, "corrupted_chorus");
        ItemRegistry.addItem((Item)heart_food, "heart_food");
        ItemRegistry.addItem((Item)new ItemFoodCrafting(), "crafting_food");
        ItemRegistry.addItem((Item)new ItemFoodInventory(), "inventory_food");
        ItemRegistry.addItem(new ItemSleepingBag(), "sleeping_mat");
        ItemRegistry.addItem((Item)potion_viscous, "potion_viscous");
        ItemRegistry.addItem((Item)potion_boost, "potion_boost");
        ItemRegistry.addItem((Item)potion_boost_long, "potion_boost_long");
        ItemRegistry.addItem((Item)potion_resistance, "potion_resistance");
        ItemRegistry.addItem((Item)potion_resistance_long, "potion_resistance_long");
        ItemRegistry.addItem((Item)potion_resistance_strong, "potion_resistance_strong");
        ItemRegistry.addItem((Item)potion_waterwalk, "potion_waterwalk");
        ItemRegistry.addItem((Item)potion_waterwalk_long, "potion_waterwalk_long");
        ItemRegistry.addItem((Item)potion_slowfall, "potion_slowfall");
        ItemRegistry.addItem((Item)potion_slowfall_long, "potion_slowfall_long");
        ItemRegistry.addItem((Item)potion_magnet, "potion_magnet");
        ItemRegistry.addItem((Item)potion_magnet_long, "potion_magnet_long");
        ItemRegistry.addItem((Item)potion_haste, "potion_haste");
        ItemRegistry.addItem((Item)potion_haste_long, "potion_haste_long");
        ItemRegistry.addItem((Item)potion_haste_strong, "potion_haste_strong");
        ItemRegistry.addItem((Item)potion_ender, "potion_ender");
        ItemRegistry.addItem((Item)potion_ender_long, "potion_ender_long");
        ItemRegistry.addItem((Item)potion_luck, "potion_luck");
        ItemRegistry.addItem((Item)potion_luck_long, "potion_luck_long");
        ItemRegistry.addItem((Item)potion_levitation, "potion_levitation");
        ItemRegistry.addItem((Item)potion_levitation_long, "potion_levitation_long");
        ItemRegistry.addItem(cyclic_wand_build, "cyclic_wand_build");
        ItemRegistry.addItem((Item)new ItemAppleEmerald(), "apple_emerald");
    }

    private static Item addItem(Item i, String key) {
        i.func_77655_b(key);
        itemMap.put(key, i);
        return i;
    }

    public static void syncConfig(Configuration config) {
        for (String key : itemMap.keySet()) {
            Item item = itemMap.get(key);
            if (!(item instanceof IHasConfig)) continue;
            ((IHasConfig)item).syncConfig(config);
        }
        ItemFoodHorse.syncConfig(config);
    }

    private static void registerRecipes() {
        for (String key : itemMap.keySet()) {
            Item item = itemMap.get(key);
            if (!(item instanceof IHasRecipe)) continue;
            ((IHasRecipe)item).addRecipe();
        }
        ItemStack awkward = BrewingRecipeRegistry.getOutput((ItemStack)new ItemStack((Item)Items.field_151068_bn), (ItemStack)new ItemStack(Items.field_151075_bm));
        BrewingRecipeRegistry.addRecipe((ItemStack)awkward, (ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()), (ItemStack)new ItemStack((Item)potion_viscous));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)potion_viscous), (ItemStack)new ItemStack(Items.field_185161_cS), (ItemStack)new ItemStack((Item)potion_levitation));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)potion_levitation), (ItemStack)new ItemStack(Items.field_151137_ax), (ItemStack)new ItemStack((Item)potion_levitation_long));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)potion_viscous), (ItemStack)new ItemStack(Items.field_151123_aH), (ItemStack)new ItemStack((Item)potion_luck));
        ItemRegistry.addBrewingRecipe((Item)potion_viscous, Items.field_151061_bv, (Item)potion_ender);
        ItemRegistry.addBrewingRecipe((Item)potion_ender, Items.field_151137_ax, (Item)potion_ender_long);
        ItemRegistry.addBrewingRecipe((Item)potion_viscous, Items.field_151166_bC, (Item)potion_haste);
        ItemRegistry.addBrewingRecipe((Item)potion_haste, Items.field_151137_ax, (Item)potion_haste_long);
        ItemRegistry.addBrewingRecipe((Item)potion_haste, Items.field_151114_aO, (Item)potion_haste_strong);
        ItemRegistry.addBrewingRecipe((Item)potion_viscous, Items.field_179563_cD, (Item)potion_waterwalk);
        ItemRegistry.addBrewingRecipe((Item)potion_waterwalk, Items.field_151137_ax, (Item)potion_waterwalk_long);
        ItemRegistry.addBrewingRecipe((Item)potion_viscous, Items.field_151153_ao, (Item)potion_boost);
        ItemRegistry.addBrewingRecipe((Item)potion_boost, Items.field_151137_ax, (Item)potion_boost_long);
        ItemRegistry.addBrewingRecipe((Item)potion_viscous, Items.field_151045_i, (Item)potion_resistance);
        ItemRegistry.addBrewingRecipe((Item)potion_resistance, Items.field_151137_ax, (Item)potion_resistance_long);
        ItemRegistry.addBrewingRecipe((Item)potion_resistance, Items.field_151114_aO, (Item)potion_resistance_strong);
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)potion_viscous), (ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), (ItemStack)new ItemStack((Item)potion_magnet));
        ItemRegistry.addBrewingRecipe((Item)potion_magnet, Items.field_151137_ax, (Item)potion_magnet_long);
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)potion_viscous), (ItemStack)new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), (ItemStack)new ItemStack((Item)potion_slowfall));
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)potion_slowfall), (ItemStack)new ItemStack(Items.field_151137_ax), (ItemStack)new ItemStack((Item)potion_slowfall_long));
    }

    private static void addBrewingRecipe(Item input, Item ingredient, Item output) {
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack(input), (ItemStack)new ItemStack(ingredient), (ItemStack)new ItemStack(output));
    }

    public static void register() {
        ItemRegistry.registerMaterials();
        ItemRegistry.addItem((Item)new ItemEmeraldSword(), "emerald_sword");
        ItemRegistry.addItem((Item)new ItemEmeraldPickaxe(), "emerald_pickaxe");
        ItemRegistry.addItem((Item)new ItemEmeraldAxe(), "emerald_axe");
        ItemRegistry.addItem((Item)new ItemEmeraldSpade(), "emerald_spade");
        ItemRegistry.addItem((Item)new ItemEmeraldHoe(), "emerald_hoe");
        ItemRegistry.addItem((Item)new ItemEmeraldArmor(EntityEquipmentSlot.HEAD), "emerald_helmet");
        ItemRegistry.addItem((Item)new ItemEmeraldArmor(EntityEquipmentSlot.CHEST), "emerald_chestplate");
        ItemRegistry.addItem((Item)new ItemEmeraldArmor(EntityEquipmentSlot.LEGS), "emerald_leggings");
        emerald_boots = new ItemEmeraldArmor(EntityEquipmentSlot.FEET);
        ItemRegistry.addItem((Item)emerald_boots, "emerald_boots");
        potion_ender.addEffect(PotionRegistry.ender, 180, 0);
        potion_magnet.addEffect(PotionRegistry.magnet, 180, 0);
        potion_waterwalk.addEffect(PotionRegistry.waterwalk, 180, 0);
        potion_slowfall.addEffect(PotionRegistry.slowfall, 180, 0);
        potion_ender_long.addEffect(PotionRegistry.ender, 480, 0);
        potion_magnet_long.addEffect(PotionRegistry.magnet, 480, 0);
        potion_waterwalk_long.addEffect(PotionRegistry.waterwalk, 480, 0);
        potion_slowfall_long.addEffect(PotionRegistry.slowfall, 480, 0);
        for (String key : itemMap.keySet()) {
            Item item = itemMap.get(key);
            if (item instanceof BaseItem) {
                ((BaseItem)item).register(key);
                continue;
            }
            ItemRegistry.registerItem(item, key);
        }
        ItemRegistry.registerRecipes();
    }

    private static void registerMaterials() {
        ARMOR_MATERIAL_EMERALD = EnumHelper.addArmorMaterial((String)emeraldName, (String)"cyclicmagic:emerald", (int)31, (int[])new int[]{ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.FEET), ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.LEGS), ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.CHEST), ItemArmor.ArmorMaterial.DIAMOND.func_78044_b(EntityEquipmentSlot.HEAD)}, (int)ItemArmor.ArmorMaterial.GOLD.func_78045_a(), (SoundEvent)ItemArmor.ArmorMaterial.DIAMOND.func_185017_b(), (float)(ItemArmor.ArmorMaterial.DIAMOND.func_189416_e() / 2.0f));
        TOOL_MATERIAL_EMERALD = EnumHelper.addToolMaterial((String)emeraldName, (int)Item.ToolMaterial.DIAMOND.func_77996_d(), (int)(Item.ToolMaterial.DIAMOND.func_77997_a() - 261), (float)Item.ToolMaterial.DIAMOND.func_77998_b(), (float)(Item.ToolMaterial.DIAMOND.func_78000_c() - 0.25f), (int)Item.ToolMaterial.GOLD.func_77995_e());
    }

    public static void registerItem(Item item, String name) {
        ItemRegistry.registerItem(item, name, false);
    }

    public static void registerItem(Item item, String name, boolean isHidden) {
        GameRegistry.register((IForgeRegistryEntry)item, (ResourceLocation)new ResourceLocation("cyclicmagic", name));
        if (!isHidden) {
            item.func_77637_a(ModMain.TAB);
        }
    }

    static {
        tool_push = new ItemToolPush();
        REPAIR_EMERALD = Items.field_151166_bC;
    }
}

