/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class MobSpawningRegistry {
    private static final int group = 3;
    private static final int min = 1;
    private static final int max = 4;
    private static boolean blazeDesertHills;
    private static boolean magmaDesert;
    private static boolean caveSpiderMesaRoofed;
    private static boolean ghastDeepOcean;
    private static boolean guardianRiver;
    private static boolean snowmanIcePlainsMount;
    private static boolean horseIceExtrhillsOcean;
    private static boolean ironGolemJungle;

    public static void register() {
        if (blazeDesertHills) {
            EntityRegistry.addSpawn(EntityBlaze.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76786_s});
        }
        if (magmaDesert) {
            EntityRegistry.addSpawn(EntityMagmaCube.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_76786_s, Biomes.field_76769_d});
        }
        if (caveSpiderMesaRoofed) {
            EntityRegistry.addSpawn(EntityCaveSpider.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_150589_Z, Biomes.field_150585_R});
        }
        if (ghastDeepOcean) {
            EntityRegistry.addSpawn(EntityGhast.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{Biomes.field_150575_M});
        }
        if (guardianRiver) {
            EntityRegistry.addSpawn(EntityGuardian.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (Biome[])new Biome[]{Biomes.field_76781_i});
        }
        if (snowmanIcePlainsMount) {
            EntityRegistry.addSpawn(EntitySnowman.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76775_o, Biomes.field_76774_n});
        }
        if (horseIceExtrhillsOcean) {
            EntityRegistry.addSpawn(EntityHorse.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76770_e, Biomes.field_76774_n});
        }
        if (ironGolemJungle) {
            EntityRegistry.addSpawn(EntityIronGolem.class, (int)3, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76792_x, Biomes.field_76782_w});
        }
    }

    public static void syncConfig(Configuration config) {
        String category = "cyclicmagic.Mob Spawns";
        config.addCustomCategoryComment(category, "Add mob spawns in more biomes");
        blazeDesertHills = config.getBoolean("Blaze DesertHills", category, true, "Adds random Blaze spawns into Desert Hills");
        magmaDesert = config.getBoolean("Magmacube Desert", category, true, "Adds random Magma Cube spawns into Desert");
        caveSpiderMesaRoofed = config.getBoolean("CaveSpider Mesa&Roofed", category, true, "Adds random Cave Spider spawns into Mesa and Roofed Forests");
        ghastDeepOcean = config.getBoolean("Ghast DeepOcean", category, true, "Adds random Ghast spawns into Deep Oceans");
        guardianRiver = config.getBoolean("Guardian River", category, true, "Adds random Guardian spawns into Rivers");
        snowmanIcePlainsMount = config.getBoolean("Snowman Ice", category, true, "Adds random Snowman spawns into Ice Plains and Ice Mountains");
        horseIceExtrhillsOcean = config.getBoolean("Horse IceHills", category, true, "Adds random Horse spawns into Extreme Hills and Ice Plains");
        ironGolemJungle = config.getBoolean("IronGolem Jungle", category, true, "Adds random IronGolem spawns into the Jungle");
    }
}

