/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.item.ItemCyclicWand;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.spell.ISpell;
import com.lothrazar.cyclicmagic.spell.SpellInventory;
import com.lothrazar.cyclicmagic.spell.SpellRangeBuild;
import com.lothrazar.cyclicmagic.spell.SpellRangePull;
import com.lothrazar.cyclicmagic.spell.SpellRangePush;
import com.lothrazar.cyclicmagic.spell.SpellRangeRotate;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class SpellRegistry {
    public static boolean renderOnLeft;
    private static Map<Integer, ISpell> hashbook;

    public static void register() {
        hashbook = new HashMap<Integer, ISpell>();
        int spellId = -1;
        Spells.inventory = new SpellInventory(++spellId, "inventory");
        SpellRegistry.registerSpell(Spells.inventory);
        Spells.rotate = new SpellRangeRotate(++spellId, "rotate");
        SpellRegistry.registerSpell(Spells.rotate);
        Spells.push = new SpellRangePush(++spellId, "push");
        SpellRegistry.registerSpell(Spells.push);
        Spells.pull = new SpellRangePull(++spellId, "pull");
        SpellRegistry.registerSpell(Spells.pull);
        Spells.reachup = new SpellRangeBuild(++spellId, "reachup", SpellRangeBuild.PlaceType.UP);
        SpellRegistry.registerSpell(Spells.reachup);
        Spells.reachplace = new SpellRangeBuild(++spellId, "reachplace", SpellRangeBuild.PlaceType.PLACE);
        SpellRegistry.registerSpell(Spells.reachplace);
        Spells.reachdown = new SpellRangeBuild(++spellId, "reachdown", SpellRangeBuild.PlaceType.DOWN);
        SpellRegistry.registerSpell(Spells.reachdown);
        SpellRangeBuild reachleft = new SpellRangeBuild(++spellId, "reachleft", SpellRangeBuild.PlaceType.LEFT);
        SpellRegistry.registerSpell(reachleft);
        SpellRangeBuild reachright = new SpellRangeBuild(++spellId, "reachright", SpellRangeBuild.PlaceType.RIGHT);
        SpellRegistry.registerSpell(reachright);
        ArrayList<ISpell> spellbookBuild = new ArrayList<ISpell>();
        spellbookBuild.add(Spells.inventory);
        spellbookBuild.add(Spells.reachup);
        spellbookBuild.add(Spells.reachplace);
        spellbookBuild.add(Spells.reachdown);
        spellbookBuild.add(reachleft);
        spellbookBuild.add(reachright);
        ItemRegistry.cyclic_wand_build.setSpells(spellbookBuild);
    }

    private static void registerSpell(ISpell spell) {
        hashbook.put(spell.getID(), spell);
    }

    public static boolean spellsEnabled(EntityPlayer player) {
        return UtilSpellCaster.getPlayerWandIfHeld(player) != null;
    }

    public static ISpell getSpellFromID(int id) {
        if (hashbook.containsKey(id)) {
            return hashbook.get(id);
        }
        return null;
    }

    public static void syncConfig(Configuration config) {
    }

    public static List<ISpell> getSpellbook(ItemStack wand) {
        return ((ItemCyclicWand)wand.func_77973_b()).getSpells();
    }

    public static ISpell next(ItemStack wand, ISpell spell) {
        List<ISpell> book = SpellRegistry.getSpellbook(wand);
        int indexCurrent = book.indexOf(spell);
        int indexNext = indexCurrent + 1;
        if (indexNext >= book.size()) {
            indexNext = 0;
        }
        return book.get(indexNext);
    }

    public static ISpell prev(ItemStack wand, ISpell spell) {
        List<ISpell> book = SpellRegistry.getSpellbook(wand);
        int indexCurrent = book.indexOf(spell);
        int indexPrev = indexCurrent <= 0 ? book.size() - 1 : indexCurrent - 1;
        ISpell ret = book.get(indexPrev);
        return ret;
    }

    public static class Spells {
        public static SpellRangeRotate rotate;
        public static SpellRangePush push;
        public static SpellRangePull pull;
        private static SpellInventory inventory;
        private static SpellRangeBuild reachdown;
        private static SpellRangeBuild reachup;
        private static SpellRangeBuild reachplace;
    }
}

