/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.lothrazar.cyclicmagic.world.gen.WorldGenEmeraldHeight;
import com.lothrazar.cyclicmagic.world.gen.WorldGenEndOre;
import com.lothrazar.cyclicmagic.world.gen.WorldGenGoldRiver;
import com.lothrazar.cyclicmagic.world.gen.WorldGenNetherOre;
import com.lothrazar.cyclicmagic.world.gen.WorldGenOcean;
import com.lothrazar.cyclicmagic.world.gen.WorldGenOreSingleton;
import com.lothrazar.cyclicmagic.world.gen.WorldGenPlantBiome;
import java.util.Arrays;
import net.minecraft.block.BlockCrops;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldGenRegistry {
    public static boolean oceanEnabled;
    public static boolean netherOreEnabled;
    public static boolean endOreEnabled;
    public static boolean oreSpawns;
    private static boolean emeraldHeight;
    private static boolean goldRiver;
    private static boolean oreSingletons;
    private static boolean biomeCrops;
    static final int weight = 0;

    public static void syncConfig(Configuration config) {
        String category = "cyclicmagic.world generation";
        config.setCategoryComment(category, "Control any blocks that get generated in new chunks & new worlds");
        Property prop = config.get(category, "Classic Oceans", true, "Generate clay, sand, and dirt in the ocean instead of only gravel (like the old days)");
        prop.setRequiresWorldRestart(true);
        oceanEnabled = prop.getBoolean();
        prop = config.get(category, "Nether Ore", true, "Generate ore in netherrack (lapis, emerald, gold, coal, diamond).  The gold gives nuggets when mined");
        prop.setRequiresMcRestart(true);
        netherOreEnabled = prop.getBoolean();
        prop = config.get(category, "End Ore", true, "Generate ore in the end (lapis, emerald, redstone, coal, diamond)");
        prop.setRequiresMcRestart(true);
        endOreEnabled = prop.getBoolean();
        prop = config.get(category, "Infested Ores", true, "These dimension ores (nether and end) have a chance to spawn endermites or silverfish");
        oreSpawns = prop.getBoolean();
        prop = config.get(category, "Emerald Ore Boost", true, "Vanilla emerald ore now can spawn at any height, not only below the ground [still only in the Extreme Hills biomes as normal]");
        prop.setRequiresMcRestart(true);
        emeraldHeight = prop.getBoolean();
        prop = config.get(category, "Gold Rivers", true, "Vanilla gold ore can spawn in and river biomes at any height");
        prop.setRequiresMcRestart(true);
        goldRiver = prop.getBoolean();
        prop = config.get(category, "Ore Singletons", true, "Vanilla ores of all kinds can rarely spawn at all world heights, but only in veins of size one.  Great for amplified terrain.");
        prop.setRequiresMcRestart(true);
        oreSingletons = prop.getBoolean();
        prop = config.get(category, "Biome Crops", true, "Crops spawn randomly with nature.  Carrots in extreme hills, wheat in plains, beetroot in forests, potatoes in taiga.");
        prop.setRequiresMcRestart(true);
        biomeCrops = prop.getBoolean();
    }

    public static void register() {
        if (oceanEnabled) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOcean(), (int)0);
        }
        if (netherOreEnabled) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenNetherOre(), (int)0);
        }
        if (endOreEnabled) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenEndOre(), (int)0);
        }
        if (emeraldHeight) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenEmeraldHeight(), (int)0);
        }
        if (goldRiver) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenGoldRiver(), (int)0);
        }
        if (oreSingletons) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150366_p, 68), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150352_o, 34), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150369_x, 34), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150450_ax, 16), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOreSingleton(Blocks.field_150482_ag, 16), (int)0);
        }
        if (biomeCrops) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_150459_bM, Arrays.asList(Biomes.field_76770_e), 15), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_150464_aj, Arrays.asList(Biomes.field_76772_c), 8), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_185773_cZ, Arrays.asList(Biomes.field_76767_f, Biomes.field_150583_P), 18), (int)0);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenPlantBiome((BlockCrops)Blocks.field_150469_bN, Arrays.asList(Biomes.field_76768_g), 10), (int)0);
        }
    }

    static {
        oreSpawns = true;
        emeraldHeight = true;
    }
}

