/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.spell;

import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.spell.ISpell;
import com.lothrazar.cyclicmagic.util.UtilSound;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BaseSpell
implements ISpell {
    private ResourceLocation icon;
    private int ID;
    private String name;

    protected void init(int id, String n) {
        this.ID = id;
        this.name = n;
        this.icon = new ResourceLocation("cyclicmagic", "textures/spells/" + this.name + ".png");
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)("spell." + this.name + ".name"), (Object[])new Object[0]);
    }

    @Override
    public String getUnlocalizedName() {
        return this.name;
    }

    @Override
    public String getInfo() {
        return I18n.func_135052_a((String)("spell." + this.name + ".info"), (Object[])new Object[0]);
    }

    @Override
    public void onCastFailure(World world, EntityPlayer player, BlockPos pos) {
        UtilSound.playSound(player, pos, SoundRegistry.buzzp);
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public boolean canPlayerCast(World world, EntityPlayer player, BlockPos pos) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack wand = UtilSpellCaster.getPlayerWandIfHeld(player);
        return wand != null;
    }

    @Override
    public ResourceLocation getIconDisplay() {
        return this.icon;
    }
}

