/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.spell;

import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.gui.wand.InventoryWand;
import com.lothrazar.cyclicmagic.item.ItemCyclicWand;
import com.lothrazar.cyclicmagic.net.PacketSpellFromServer;
import com.lothrazar.cyclicmagic.spell.BaseSpellRange;
import com.lothrazar.cyclicmagic.spell.ISpellFromServer;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilSpellCaster;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellRangeBuild
extends BaseSpellRange
implements ISpellFromServer {
    static final int max = 32;
    private PlaceType type;

    public SpellRangeBuild(int id, String n, PlaceType t) {
        super.init(id, n);
        this.type = t;
    }

    @Override
    public boolean cast(World world, EntityPlayer p, ItemStack wand, BlockPos pos, EnumFacing side) {
        if (world.field_72995_K) {
            BlockPos mouseover = ModMain.proxy.getBlockMouseoverExact(maxRange);
            BlockPos offset = ModMain.proxy.getBlockMouseoverOffset(maxRange);
            if (mouseover != null && offset != null) {
                ModMain.network.sendToServer((IMessage)new PacketSpellFromServer(mouseover, offset, this.getID()));
            }
        }
        return true;
    }

    @Override
    public void castFromServer(BlockPos posMouseover, BlockPos posOffset, EntityPlayer p) {
        World world = p.field_70170_p;
        ItemStack heldWand = UtilSpellCaster.getPlayerWandIfHeld(p);
        if (heldWand == null) {
            return;
        }
        int itemSlot = ItemCyclicWand.BuildType.getSlot(heldWand);
        IBlockState state = InventoryWand.getToPlaceFromSlot(heldWand, itemSlot);
        if (state == null || state.func_177230_c() == null) {
            ItemCyclicWand.BuildType.setNextSlot(heldWand);
            itemSlot = ItemCyclicWand.BuildType.getSlot(heldWand);
            state = InventoryWand.getToPlaceFromSlot(heldWand, itemSlot);
            if (state == null || state.func_177230_c() == null) {
                UtilChat.addChatMessage(p, "wand.inventory.empty");
                return;
            }
        }
        BlockPos posToPlaceAt = null;
        EnumFacing facing = null;
        EnumFacing playerFacing = p.func_174811_aO();
        block0 : switch (this.type) {
            case DOWN: {
                facing = EnumFacing.DOWN;
                break;
            }
            case UP: {
                facing = EnumFacing.UP;
                break;
            }
            case LEFT: {
                switch (playerFacing) {
                    case DOWN: {
                        break block0;
                    }
                    case EAST: {
                        facing = EnumFacing.NORTH;
                        break block0;
                    }
                    case NORTH: {
                        facing = EnumFacing.WEST;
                        break block0;
                    }
                    case SOUTH: {
                        facing = EnumFacing.EAST;
                        break block0;
                    }
                    case UP: {
                        break block0;
                    }
                    case WEST: {
                        facing = EnumFacing.SOUTH;
                        break block0;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (playerFacing) {
                    case DOWN: {
                        break block0;
                    }
                    case EAST: {
                        facing = EnumFacing.SOUTH;
                        break block0;
                    }
                    case NORTH: {
                        facing = EnumFacing.EAST;
                        break block0;
                    }
                    case SOUTH: {
                        facing = EnumFacing.WEST;
                        break block0;
                    }
                    case UP: {
                        break block0;
                    }
                    case WEST: {
                        facing = EnumFacing.NORTH;
                        break block0;
                    }
                }
                break;
            }
            case PLACE: {
                break;
            }
        }
        if (facing == null) {
            posToPlaceAt = posOffset;
        } else {
            BlockPos posLoop = posMouseover;
            for (int i = 0; i < 32; ++i) {
                if (world.func_175623_d(posLoop)) {
                    posToPlaceAt = posLoop;
                    break;
                }
                posLoop = posLoop.func_177972_a(facing);
            }
        }
        if (UtilPlaceBlocks.placeStateSafe(p.field_70170_p, p, posToPlaceAt, state)) {
            if (!p.field_71075_bZ.field_75098_d) {
                InventoryWand.decrementSlot(heldWand, itemSlot);
            }
            ItemCyclicWand.BuildType.setNextSlot(heldWand);
            this.spawnParticle(p.field_70170_p, p, posMouseover);
            Block newSpot = null;
            if (p.field_70170_p.func_180495_p(posToPlaceAt) != null) {
                newSpot = p.field_70170_p.func_180495_p(posToPlaceAt).func_177230_c();
                this.playSound(p.field_70170_p, p, newSpot, posToPlaceAt);
            }
        }
    }

    public static enum PlaceType {
        PLACE,
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

