/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.util.Vector3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class UtilEntity {
    public static void teleportWallSafe(EntityLivingBase player, World world, BlockPos coords) {
        player.func_70634_a((double)coords.func_177958_n(), (double)coords.func_177956_o(), (double)coords.func_177952_p());
        UtilEntity.moveEntityWallSafe(player, world);
    }

    public static void moveEntityWallSafe(EntityLivingBase entity, World world) {
        while (world.func_184143_b(entity.func_174813_aQ())) {
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
    }

    public static void setMaxHealth(EntityLivingBase living, double max) {
        living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(max);
    }

    public static double getMaxHealth(EntityLivingBase living) {
        return living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
    }

    public static int incrementMaxHealth(EntityLivingBase living, int by) {
        int newVal = (int)UtilEntity.getMaxHealth(living) + by;
        UtilEntity.setMaxHealth(living, newVal);
        return newVal;
    }

    public static EnumFacing getPlayerFacing(EntityLivingBase entity) {
        int yaw = (int)entity.field_70177_z;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 22;
        int facing = (yaw %= 360) / 45;
        return EnumFacing.func_176731_b((int)(facing / 2));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, Block block) {
        return UtilEntity.dropItemStackInWorld(worldObj, pos, new ItemStack(block));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, Item item) {
        return UtilEntity.dropItemStackInWorld(worldObj, pos, new ItemStack(item));
    }

    public static EntityItem dropItemStackInWorld(World worldObj, BlockPos pos, ItemStack stack) {
        EntityItem entityItem = new EntityItem(worldObj, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        if (!worldObj.field_72995_K) {
            worldObj.func_72838_d((Entity)entityItem);
        }
        return entityItem;
    }

    public static double getSpeedTranslated(double speed) {
        return speed * 100.0;
    }

    public static double getJumpTranslated(double jump) {
        double jumpHeight = 0.0;
        double gravity = 0.98;
        while (jump > 0.0) {
            jumpHeight += jump;
            jump -= 0.08;
            jump *= gravity;
        }
        return jumpHeight;
    }

    public static void launchDirection(Entity entity, float rotationPitch, float power, EnumFacing facing) {
        double velX = 0.0;
        double velZ = 0.0;
        double velY = 0.0;
        switch (facing) {
            case EAST: {
                velX = Math.abs(power);
                velZ = 0.0;
                break;
            }
            case WEST: {
                velX = -1.0f * Math.abs(power);
                velZ = 0.0;
                break;
            }
            case NORTH: {
                velX = 0.0;
                velZ = -1.0f * Math.abs(power);
                break;
            }
            case SOUTH: {
                velX = 0.0;
                velZ = Math.abs(power);
                break;
            }
        }
        Entity ridingEntity = entity.func_184187_bx();
        if (ridingEntity != null) {
            ridingEntity.field_70181_x = 0.0;
            ridingEntity.field_70143_R = 0.0f;
            ridingEntity.func_70024_g(velX, velY, velZ);
        } else {
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
            entity.func_70024_g(velX, velY, velZ);
        }
    }

    public static void launch(Entity entity, float rotationPitch, float power) {
        Entity ridingEntity;
        float rotationYaw = entity.field_70177_z;
        float mountPower = (float)((double)power - 0.5);
        double velX = -MathHelper.func_76126_a((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velZ = MathHelper.func_76134_b((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        double velY = -MathHelper.func_76126_a((float)(rotationPitch / 180.0f * (float)Math.PI)) * power;
        if (velY < 0.0) {
            velY *= -1.0;
        }
        if ((ridingEntity = entity.func_184187_bx()) != null) {
            ridingEntity.field_70181_x = 0.0;
            ridingEntity.field_70143_R = 0.0f;
            ridingEntity.func_70024_g(velX * (double)mountPower, velY * (double)mountPower, velZ * (double)mountPower);
        } else {
            entity.field_70181_x = 0.0;
            entity.field_70143_R = 0.0f;
            entity.func_70024_g(velX, velY, velZ);
        }
    }

    public static int pullEntityItemsTowards(World world, BlockPos pos, float ITEMSPEED, int ITEM_HRADIUS, int ITEM_VRADIUS) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        List found = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(x - ITEM_HRADIUS), (double)(y - ITEM_VRADIUS), (double)(z - ITEM_HRADIUS), (double)(x + ITEM_HRADIUS), (double)(y + ITEM_VRADIUS), (double)(z + ITEM_HRADIUS)));
        int moved = 0;
        for (EntityItem eitem : found) {
            Vector3.setEntityMotionFromVector((Entity)eitem, x, y, z, ITEMSPEED);
            ++moved;
        }
        List foundExp = world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((double)(x - ITEM_HRADIUS), (double)(y - ITEM_VRADIUS), (double)(z - ITEM_HRADIUS), (double)(x + ITEM_HRADIUS), (double)(y + ITEM_VRADIUS), (double)(z + ITEM_HRADIUS)));
        for (EntityXPOrb eitem : foundExp) {
            Vector3.setEntityMotionFromVector((Entity)eitem, x, y, z, ITEMSPEED);
            ++moved;
        }
        return moved;
    }
}

