/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UtilHarvestCrops {
    public static int harvestArea(World world, BlockPos pos, int xRadius, HarestCropsConfig conf) {
        ModMain.logger.info("conf=" + conf.toString());
        int x = pos.func_177958_n();
        int eventy = pos.func_177956_o();
        int z = pos.func_177952_p();
        int xMin = x - xRadius;
        int xMax = x + xRadius;
        int zMin = z - xRadius;
        int zMax = z + xRadius;
        int countHarvested = 0;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                BlockPos posCurrent = new BlockPos(xLoop, eventy, zLoop);
                if (world.func_175623_d(posCurrent) || !UtilHarvestCrops.harvestSingle(world, posCurrent, conf)) continue;
                ++countHarvested;
            }
        }
        return countHarvested;
    }

    public static boolean harvestSingle(World world, BlockPos posCurrent, HarestCropsConfig conf) {
        IGrowable plant;
        boolean doBreakAbove = false;
        boolean doBreakBelow = false;
        boolean doBreak = false;
        boolean doReplant = false;
        IBlockState bs = world.func_180495_p(posCurrent);
        if (bs == null) {
            return false;
        }
        Block blockCheck = bs.func_177230_c();
        if (blockCheck == null) {
            return false;
        }
        IBlockState bsAbove = world.func_180495_p(posCurrent.func_177984_a());
        IBlockState bsBelow = world.func_180495_p(posCurrent.func_177977_b());
        if (blockCheck instanceof BlockNetherWart) {
            int age;
            if (conf.doesCrops && (age = ((Integer)bs.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) == 3) {
                doBreak = true;
                doReplant = true;
            }
        } else if (blockCheck instanceof BlockStem) {
            if (conf.doesHarvestStem) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockSapling) {
            if (conf.doesHarvestSapling) {
                doBreak = true;
            }
        } else if (blockCheck instanceof BlockTallGrass) {
            if (conf.doesHarvestTallgrass) {
                doBreak = true;
                doReplant = false;
                if (blockCheck instanceof BlockTallGrass && bsAbove != null && bsAbove.func_177230_c() instanceof BlockTallGrass) {
                    doBreakAbove = true;
                }
                if (bsBelow instanceof BlockTallGrass && bsBelow != null && bsBelow.func_177230_c() instanceof BlockTallGrass) {
                    doBreakBelow = true;
                }
            }
        } else if (blockCheck instanceof BlockDoublePlant) {
            if (conf.doesHarvestTallgrass) {
                doBreak = true;
                doReplant = false;
                if (blockCheck instanceof BlockDoublePlant && bsAbove != null && bsAbove.func_177230_c() instanceof BlockDoublePlant) {
                    doBreakAbove = true;
                }
                if (bsBelow instanceof BlockDoublePlant && bsBelow != null && bsBelow.func_177230_c() instanceof BlockDoublePlant) {
                    doBreakBelow = true;
                }
            }
        } else if (blockCheck instanceof BlockMushroom) {
            if (conf.doesHarvestMushroom) {
                doBreak = true;
            }
        } else if (blockCheck == Blocks.field_150423_aK) {
            if (conf.doesPumpkinBlocks) {
                doBreak = true;
                doReplant = false;
            }
        } else if (blockCheck == Blocks.field_150440_ba) {
            if (conf.doesMelonBlocks) {
                doBreak = false;
                doReplant = false;
                world.func_175655_b(posCurrent, false);
                UtilEntity.dropItemStackInWorld(world, posCurrent, Blocks.field_150440_ba);
            }
        } else if (blockCheck == Blocks.field_150328_O || blockCheck == Blocks.field_150327_N) {
            if (conf.doesFlowers) {
                doBreak = true;
                doReplant = false;
            }
        } else if (blockCheck == Blocks.field_150362_t || blockCheck == Blocks.field_150361_u) {
            if (conf.doesLeaves) {
                doBreak = true;
                doReplant = false;
            }
        } else if (blockCheck instanceof IGrowable && conf.doesCrops && !(plant = (IGrowable)blockCheck).func_176473_a(world, posCurrent, bs, world.field_72995_K)) {
            doBreak = true;
            doReplant = true;
        }
        if (doBreak) {
            ModMain.logger.info("posCurrent=" + UtilChat.blockPosToString(posCurrent));
            ModMain.logger.info("h" + blockCheck.func_149739_a());
            ModMain.logger.info("doBreakAbove=" + doBreakAbove);
            ModMain.logger.info("doBreakBelow=" + doBreakBelow);
            ModMain.logger.info("doReplant=" + doReplant);
            world.func_175655_b(posCurrent, true);
            if (doBreakAbove) {
                world.func_175655_b(posCurrent.func_177984_a(), false);
            }
            if (doBreakBelow) {
                world.func_175655_b(posCurrent.func_177977_b(), false);
            }
            if (doReplant) {
                world.func_175656_a(posCurrent, blockCheck.func_176223_P());
            }
            return true;
        }
        return false;
    }

    public static class HarestCropsConfig {
        public boolean doesHarvestStem = false;
        public boolean doesHarvestSapling = false;
        public boolean doesHarvestMushroom = false;
        public boolean doesPumpkinBlocks = false;
        public boolean doesMelonBlocks = false;
        public boolean doesFlowers = false;
        public boolean doesLeaves = false;
        public boolean doesCrops = false;
        public boolean doesHarvestTallgrass = false;

        public String toString() {
            String s = "";
            s = s + "doesHarvestStem = " + this.doesHarvestStem + System.lineSeparator();
            s = s + "doesHarvestSapling = " + this.doesHarvestSapling + System.lineSeparator();
            s = s + "doesHarvestMushroom = " + this.doesHarvestMushroom + System.lineSeparator();
            s = s + "doesPumpkinBlocks = " + this.doesPumpkinBlocks + System.lineSeparator();
            s = s + "doesMelonBlocks = " + this.doesMelonBlocks + System.lineSeparator();
            s = s + "doesFlowers = " + this.doesFlowers + System.lineSeparator();
            s = s + "doesCrops = " + this.doesCrops + System.lineSeparator();
            s = s + "doesHarvestTallgrass = " + this.doesHarvestTallgrass + System.lineSeparator();
            return s;
        }
    }
}

