/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModMain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class UtilInventorySort {
    static final String NBT_SORT = "terraria_sort";
    static final int SORT_ALPH = 0;
    static final int SORT_ALPHI = 1;

    public static void dumpFromPlayerToIInventory(World world, IInventory inventory, EntityPlayer player) {
        int start;
        block0: for (int islotInvo = start = 0; islotInvo < inventory.func_70302_i_(); ++islotInvo) {
            ItemStack chestEmptySlot = inventory.func_70301_a(islotInvo);
            if (chestEmptySlot != null) continue;
            for (int islotPlayer = 9; islotPlayer < UtilInventorySort.getInvoEnd(player); ++islotPlayer) {
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotPlayer);
                if (playerItem == null) continue;
                inventory.func_70299_a(islotInvo, playerItem);
                player.field_71071_by.func_70299_a(islotPlayer, null);
                continue block0;
            }
        }
        UtilInventorySort.updatePlayerContainerClient(player);
    }

    public static void dumpFromIInventoryToPlayer(World world, IInventory inventory, EntityPlayer player) {
        int start = 0;
        block0: for (int islotPlayer = 9; islotPlayer < UtilInventorySort.getInvoEnd(player); ++islotPlayer) {
            ItemStack playerEmptySlot = player.field_71071_by.func_70301_a(islotPlayer);
            if (playerEmptySlot != null) continue;
            for (int islotInvo = start; islotInvo < inventory.func_70302_i_(); ++islotInvo) {
                ItemStack chestItem = inventory.func_70301_a(islotInvo);
                if (chestItem == null) continue;
                player.field_71071_by.func_70299_a(islotPlayer, chestItem);
                inventory.func_70299_a(islotInvo, null);
                start = islotInvo + 1;
                continue block0;
            }
        }
        UtilInventorySort.updatePlayerContainerClient(player);
    }

    public static void sortFromPlayerToInventory(World world, IInventory chest, EntityPlayer player) {
        int START_CHEST = 0;
        int END_CHEST = chest.func_70302_i_();
        for (int islotChest = START_CHEST; islotChest < END_CHEST; ++islotChest) {
            ItemStack chestItem = chest.func_70301_a(islotChest);
            if (chestItem == null) continue;
            for (int islotInv = 9; islotInv < UtilInventorySort.getInvoEnd(player); ++islotInv) {
                int chestMax;
                int room;
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotInv);
                if (playerItem == null || !playerItem.func_77973_b().equals(chestItem.func_77973_b()) || playerItem.func_77952_i() != chestItem.func_77952_i() || (room = (chestMax = chestItem.func_77973_b().getItemStackLimit(chestItem)) - chestItem.field_77994_a) <= 0) continue;
                int toDeposit = Math.min(playerItem.field_77994_a, room);
                chestItem.field_77994_a += toDeposit;
                chest.func_70299_a(islotChest, chestItem);
                playerItem.field_77994_a -= toDeposit;
                if (playerItem.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(islotInv, null);
                    continue;
                }
                player.field_71071_by.func_70299_a(islotInv, playerItem);
            }
        }
        UtilInventorySort.updatePlayerContainerClient(player);
    }

    public static void sortFromInventoryToPlayer(World world, IInventory chest, EntityPlayer player, boolean restockLeaveOne) {
        int START_CHEST = 0;
        int END_CHEST = chest.func_70302_i_();
        for (int islotChest = START_CHEST; islotChest < END_CHEST; ++islotChest) {
            ItemStack chestItem = chest.func_70301_a(islotChest);
            if (chestItem == null) continue;
            for (int islotInv = 9; islotInv < UtilInventorySort.getInvoEnd(player); ++islotInv) {
                int invMax;
                int room;
                ItemStack playerItem = player.field_71071_by.func_70301_a(islotInv);
                if (playerItem == null || !playerItem.func_77973_b().equals(chestItem.func_77973_b()) || playerItem.func_77952_i() != chestItem.func_77952_i() || (room = (invMax = playerItem.func_77973_b().getItemStackLimit(playerItem)) - playerItem.field_77994_a) <= 0) continue;
                int toDeposit = Math.min(chestItem.field_77994_a, room);
                if (restockLeaveOne && chestItem.field_77994_a - toDeposit == 0 && --toDeposit == 0) continue;
                playerItem.field_77994_a += toDeposit;
                player.field_71071_by.func_70299_a(islotInv, playerItem);
                chestItem.field_77994_a -= toDeposit;
                if (chestItem.field_77994_a <= 0) {
                    chest.func_70299_a(islotChest, null);
                    continue;
                }
                chest.func_70299_a(islotChest, chestItem);
            }
        }
        UtilInventorySort.updatePlayerContainerClient(player);
    }

    private static int getNextSort(EntityPlayer p) {
        int prev = p.getEntityData().func_74762_e(NBT_SORT);
        int n = prev + 1;
        if (n >= 2) {
            n = 0;
        }
        p.getEntityData().func_74768_a(NBT_SORT, n);
        return n;
    }

    public static void sort(EntityPlayer player, IInventory invo) {
        int sortType = UtilInventorySort.getNextSort(player);
        int iSize = invo.func_70302_i_();
        HashMap<String, SortGroup> unames = new HashMap<String, SortGroup>();
        ItemStack item = null;
        String key = "";
        for (int i = 0; i < iSize; ++i) {
            item = invo.func_70301_a(i);
            if (item == null) continue;
            if (sortType == 0) {
                key = item.func_77977_a() + item.func_77952_i();
            } else if (sortType == 1) {
                key = item.func_77973_b().getClass().getName() + item.func_77977_a() + item.func_77952_i();
            }
            SortGroup temp = (SortGroup)unames.get(key);
            if (temp == null) {
                temp = new SortGroup(key);
            }
            if (temp.stacks.size() > 0) {
                ItemStack top = temp.stacks.remove(temp.stacks.size() - 1);
                int room = top.func_77976_d() - top.field_77994_a;
                if (room > 0) {
                    int moveover = Math.min(item.field_77994_a, room);
                    top.field_77994_a += moveover;
                    item.field_77994_a -= moveover;
                    if (item.field_77994_a == 0) {
                        item = null;
                        invo.func_70299_a(i, item);
                    }
                }
                temp.stacks.add(top);
            }
            if (item != null) {
                temp.add(item);
            }
            unames.put(key, temp);
        }
        ArrayList sorted = new ArrayList(unames.values());
        Collections.sort(sorted, new Comparator<SortGroup>(){

            @Override
            public int compare(SortGroup o1, SortGroup o2) {
                return o1.key.compareTo(o2.key);
            }
        });
        for (SortGroup p : sorted) {
            for (int i = 0; i < p.stacks.size(); ++i) {
                invo.func_70299_a(i, null);
                invo.func_70299_a(i, p.stacks.get(i));
            }
        }
        for (int j = 0; j < iSize; ++j) {
            invo.func_70299_a(j, null);
        }
        UtilInventorySort.updatePlayerContainerClient(player);
    }

    private static int getInvoEnd(EntityPlayer p) {
        return p.field_71071_by.func_70302_i_() - 4;
    }

    public static void updatePlayerContainerClient(EntityPlayer p) {
        p.field_71071_by.func_70296_d();
        if (p.field_71070_bA == null) {
            ModMain.logger.error("Cannot update null container");
        } else {
            p.field_71070_bA.func_75142_b();
        }
    }

    public static class SortGroup {
        public ArrayList<ItemStack> stacks = new ArrayList();
        public String key;

        public SortGroup(String k) {
            this.key = k;
        }

        public void add(ItemStack s) {
            this.stacks.add(s);
        }
    }
}

