/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class UtilNBT {
    public static String posToStringCSV(BlockPos position) {
        return position.func_177958_n() + "," + position.func_177956_o() + "," + position.func_177952_p();
    }

    public static void setItemStackNBTVal(ItemStack item, String prop, int value) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        item.func_77978_p().func_74768_a(prop, value);
    }

    public static int getItemStackNBTVal(ItemStack held, String prop) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(held);
        if (!tags.func_74764_b(prop)) {
            return 0;
        }
        return tags.func_74762_e(prop);
    }

    public static NBTTagCompound getItemStackNBT(ItemStack held) {
        if (held.func_77978_p() == null) {
            held.func_77982_d(new NBTTagCompound());
        }
        return held.func_77978_p();
    }

    public static BlockPos stringCSVToBlockPos(String csv) {
        String[] spl = csv.split(",");
        BlockPos p = null;
        try {
            if (spl != null && spl.length == 3 && spl[0] != "") {
                p = new BlockPos(Integer.parseInt(spl[0]), Integer.parseInt(spl[1]), Integer.parseInt(spl[2]));
            }
        }
        catch (ClassCastException e) {
            System.out.println("exc: bad string: " + csv);
        }
        return p;
    }

    public static void incrementPlayerIntegerNBT(EntityPlayer player, String prop, int inc) {
        int prev = player.getEntityData().func_74762_e(prop);
        player.getEntityData().func_74768_a(prop, prev += inc);
    }

    public static void writeTagsToInventory(IInventory invo, NBTTagCompound tags, String key) {
        NBTTagList items = tags.func_150295_c(key, (int)tags.func_74732_a());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)item);
            int slot = item.func_74762_e("slot");
            invo.func_70299_a(slot, stack);
        }
    }

    public static NBTTagCompound writeInventoryToTag(IInventory invo, NBTTagCompound returnTag, String key) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < invo.func_70302_i_(); ++i) {
            ItemStack chestItem = invo.func_70301_a(i);
            if (chestItem == null || chestItem.field_77994_a == 0) continue;
            NBTTagCompound itemTag = chestItem.func_77955_b(new NBTTagCompound());
            itemTag.func_74768_a("slot", i);
            nbttaglist.func_74742_a((NBTBase)itemTag);
            invo.func_70299_a(i, null);
        }
        returnTag.func_74782_a(key, (NBTBase)nbttaglist);
        return returnTag;
    }

    public static NBTTagCompound writeInventoryToNewTag(IInventory invo, String key) {
        return UtilNBT.writeInventoryToTag(invo, new NBTTagCompound(), key);
    }

    public static int countItemsFromNBT(NBTTagCompound tags, String key) {
        if (tags == null) {
            return 0;
        }
        NBTTagList items = tags.func_150295_c(key, (int)tags.func_74732_a());
        if (items == null) {
            return 0;
        }
        return items.func_74745_c();
    }

    public static ArrayList<ItemStack> readItemsFromNBT(NBTTagCompound tags, String key) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        NBTTagList items = tags.func_150295_c(key, (int)tags.func_74732_a());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            list.add(ItemStack.func_77949_a((NBTTagCompound)item));
        }
        return list;
    }

    public static ItemStack enchantItem(Item item, Enchantment ench, short level) {
        ItemStack stack = new ItemStack(item);
        stack.func_77966_a(ench, (int)level);
        return stack;
    }

    public static ItemStack buildEnchantedBook(Enchantment ench, short level) {
        ItemStack stack = new ItemStack((Item)Items.field_151134_bR);
        Items.field_151134_bR.func_92115_a(stack, new EnchantmentData(ench, (int)level));
        return stack;
    }

    public static ItemStack buildEnchantedNametag(String customNameTag) {
        ItemStack nameTag = new ItemStack(Items.field_151057_cb, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound display = new NBTTagCompound();
        display.func_74778_a("Name", customNameTag);
        nbt.func_74782_a("display", (NBTBase)display);
        nbt.func_74768_a("RepairCost", 1);
        nameTag.func_77982_d(nbt);
        return nameTag;
    }

    public static ItemStack buildNamedPlayerSkull(EntityPlayer player) {
        return UtilNBT.buildNamedPlayerSkull(player.getDisplayNameString());
    }

    public static ItemStack buildNamedPlayerSkull(String displayNameString) {
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
        if (skull.func_77978_p() == null) {
            skull.func_77982_d(new NBTTagCompound());
        }
        skull.func_77978_p().func_74778_a("SkullOwner", displayNameString);
        return skull;
    }
}

