/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UtilPlaceBlocks {
    public static ArrayList<Block> ignoreList = new ArrayList();

    public static List<BlockPos> repeatShapeByHeight(List<BlockPos> shape, int height) {
        ArrayList<BlockPos> newShape = new ArrayList<BlockPos>();
        newShape.addAll(shape);
        for (int i = 1; i <= height; ++i) {
            for (BlockPos p : shape) {
                newShape.add(p.func_177981_b(i));
            }
        }
        return newShape;
    }

    public static List<BlockPos> circle(BlockPos pos, int diameter) {
        int radius;
        int centerX = pos.func_177958_n();
        int centerZ = pos.func_177952_p();
        int height = pos.func_177956_o();
        int z = radius = diameter / 2;
        int x = 0;
        int d = 2 - 2 * radius;
        ArrayList<BlockPos> circleList = new ArrayList<BlockPos>();
        do {
            circleList.add(new BlockPos(centerX + x, height, centerZ + z));
            circleList.add(new BlockPos(centerX + x, height, centerZ - z));
            circleList.add(new BlockPos(centerX - x, height, centerZ + z));
            circleList.add(new BlockPos(centerX - x, height, centerZ - z));
            circleList.add(new BlockPos(centerX + z, height, centerZ + x));
            circleList.add(new BlockPos(centerX + z, height, centerZ - x));
            circleList.add(new BlockPos(centerX - z, height, centerZ + x));
            circleList.add(new BlockPos(centerX - z, height, centerZ - x));
            if (d < 0) {
                d = d + 4 * x + 6;
                continue;
            }
            d = d + 4 * (x - z) + 10;
            --z;
        } while (++x <= z);
        Collections.sort(circleList, new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos object1, BlockPos object2) {
                return object1.func_177958_n() - object2.func_177958_n();
            }
        });
        return circleList;
    }

    public static List<BlockPos> squareHorizontalHollow(BlockPos pos, int radius) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        int y = pos.func_177956_o();
        for (int x = xMin; x <= xMax; ++x) {
            shape.add(new BlockPos(x, y, zMin));
            shape.add(new BlockPos(x, y, zMax));
        }
        for (int z = zMin + 1; z < zMax; ++z) {
            shape.add(new BlockPos(xMin, y, z));
            shape.add(new BlockPos(xMax, y, z));
        }
        return shape;
    }

    public static List<BlockPos> stairway(BlockPos position, EnumFacing pfacing, int want, boolean isLookingUp) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        BlockPos posCurrent = position.func_177977_b().func_177972_a(pfacing);
        boolean goVert = false;
        for (int i = 1; i < want + 1; ++i) {
            posCurrent = goVert ? (isLookingUp ? posCurrent.func_177984_a() : posCurrent.func_177977_b()) : posCurrent.func_177972_a(pfacing);
            shape.add(posCurrent);
            goVert = i % 2 == 0;
        }
        return shape;
    }

    public static List<BlockPos> line(BlockPos pos, EnumFacing efacing, int want) {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        int skip = 1;
        for (int i = 1; i < want + 1; i += skip) {
            shape.add(pos.func_177967_a(efacing, i));
        }
        return shape;
    }

    public static boolean placeStateDetsroy(World world, EntityPlayer player, BlockPos placePos, IBlockState placeState, boolean dropBlock) {
        if (world.func_175655_b(placePos, dropBlock)) {
            return UtilPlaceBlocks.placeStateSafe(world, player, placePos, placeState);
        }
        return false;
    }

    public static boolean placeStateOverwrite(World world, EntityPlayer player, BlockPos placePos, IBlockState placeState) {
        if (world.func_175698_g(placePos)) {
            return UtilPlaceBlocks.placeStateSafe(world, player, placePos, placeState);
        }
        return false;
    }

    public static boolean placeStateSafe(World world, EntityPlayer player, BlockPos placePos, IBlockState placeState) {
        if (placePos == null) {
            return false;
        }
        IBlockState stateHere = null;
        if (!world.func_175623_d(placePos) && (stateHere = world.func_180495_p(placePos)) != null) {
            Block blockHere = stateHere.func_177230_c();
            if (!blockHere.func_176200_f((IBlockAccess)world, placePos)) {
                return false;
            }
            if (stateHere.func_185904_a() != Material.field_151586_h && stateHere.func_185904_a() != Material.field_151587_i) {
                boolean dropBlock = true;
                world.func_175655_b(placePos, dropBlock);
            }
        }
        boolean success = false;
        try {
            success = world.func_175656_a(placePos, placeState);
        }
        catch (ConcurrentModificationException e) {
            ModMain.logger.warn("ConcurrentModificationException");
            ModMain.logger.warn(e.getMessage());
            ModMain.logger.warn(e.getStackTrace().toString());
            success = false;
        }
        if (success) {
            if (player != null) {
                UtilSound.playSoundPlaceBlock(player, placePos, placeState.func_177230_c());
            } else {
                UtilSound.playSound(world, placePos, placeState.func_177230_c().func_185467_w().func_185841_e(), SoundCategory.BLOCKS);
            }
        }
        return success;
    }

    private static void translateCSV() {
        if (ignoreList.size() == 0) {
            ignoreList.add(Blocks.field_150378_br);
            ignoreList.add(Blocks.field_150384_bq);
            ignoreList.add((Block)Blocks.field_150427_aO);
            ignoreList.add(Blocks.field_150324_C);
            ignoreList.add(Blocks.field_180409_at);
            ignoreList.add(Blocks.field_180410_as);
            ignoreList.add(Blocks.field_180412_aq);
            ignoreList.add(Blocks.field_180413_ao);
            ignoreList.add(Blocks.field_180414_ap);
            ignoreList.add(Blocks.field_180411_ar);
            ignoreList.add(Blocks.field_150454_av);
            ignoreList.add((Block)Blocks.field_150465_bP);
            ignoreList.add((Block)Blocks.field_150398_cm);
        }
    }

    public static boolean moveBlockTo(World world, EntityPlayer player, BlockPos pos, BlockPos posMoveToHere) {
        IBlockState newStateToPlace = world.func_180495_p(pos);
        UtilPlaceBlocks.translateCSV();
        if (newStateToPlace == null || ignoreList.contains(newStateToPlace.func_177230_c())) {
            return false;
        }
        if (newStateToPlace.func_185887_b(world, posMoveToHere) == -1.0f) {
            return false;
        }
        boolean moved = false;
        if (world.func_175623_d(posMoveToHere) && world.func_175660_a(player, pos)) {
            TileEntity newTile;
            TileEntity tile = world.func_175625_s(pos);
            NBTTagCompound tileData = null;
            if (tile != null) {
                tileData = new NBTTagCompound();
                tile.func_189515_b(tileData);
                world.func_175713_t(pos);
            }
            world.func_175698_g(pos);
            moved = UtilPlaceBlocks.placeStateSafe(world, player, posMoveToHere, newStateToPlace);
            if (moved && tileData != null && (newTile = world.func_175625_s(posMoveToHere)) != null) {
                tileData.func_74768_a("x", posMoveToHere.func_177958_n());
                tileData.func_74768_a("y", posMoveToHere.func_177956_o());
                tileData.func_74768_a("z", posMoveToHere.func_177952_p());
                newTile.func_145839_a(tileData);
                newTile.func_70296_d();
                world.func_175646_b(posMoveToHere, newTile);
            }
        }
        return moved;
    }

    public static BlockPos pullBlock(World worldIn, EntityPlayer player, BlockPos pos, EnumFacing face) {
        BlockPos posTowardsPlayer = pos.func_177972_a(face);
        if (UtilPlaceBlocks.moveBlockTo(worldIn, player, pos, posTowardsPlayer)) {
            return posTowardsPlayer;
        }
        return null;
    }

    public static BlockPos pushBlock(World worldIn, EntityPlayer player, BlockPos pos, EnumFacing face) {
        BlockPos posAwayPlayer = pos.func_177972_a(face.func_176734_d());
        if (UtilPlaceBlocks.moveBlockTo(worldIn, player, pos, posAwayPlayer)) {
            return posAwayPlayer;
        }
        return null;
    }

    public static boolean rotateBlockValidState(BlockPos pos, World worldObj, EnumFacing side, EntityPlayer p) {
        if (pos == null || worldObj.func_180495_p(pos) == null || side == null) {
            return false;
        }
        IBlockState clicked = worldObj.func_180495_p(pos);
        if (clicked.func_177230_c() == null) {
            return false;
        }
        Block clickedBlock = clicked.func_177230_c();
        boolean isDone = clickedBlock.rotateBlock(worldObj, pos, side);
        if (isDone) {
            UtilSound.playSoundPlaceBlock(p, pos, clickedBlock);
            return true;
        }
        IBlockState placeState = null;
        if (clickedBlock == Blocks.field_150348_b) {
            BlockStone.EnumType variant = (BlockStone.EnumType)clicked.func_177229_b((IProperty)BlockStone.field_176247_a);
            switch (variant) {
                case ANDESITE: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
                    break;
                }
                case ANDESITE_SMOOTH: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
                    break;
                }
                case DIORITE: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH);
                    break;
                }
                case DIORITE_SMOOTH: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
                    break;
                }
                case GRANITE: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE_SMOOTH);
                    break;
                }
                case GRANITE_SMOOTH: {
                    placeState = clicked.func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
                    break;
                }
                case STONE: {
                    placeState = Blocks.field_150417_aV.func_176223_P();
                }
            }
        } else if (clickedBlock == Blocks.field_150417_aV) {
            if (Blocks.field_150417_aV.func_176201_c(clicked) == BlockStoneBrick.field_176248_b) {
                placeState = Blocks.field_150417_aV.func_176203_a(BlockStoneBrick.field_176252_O);
            } else if (Blocks.field_150417_aV.func_176201_c(clicked) == BlockStoneBrick.field_176252_O) {
                placeState = Blocks.field_150348_b.func_176223_P();
            }
        }
        if (placeState != null) {
            isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, placeState);
        }
        if (isDone) {
            return true;
        }
        for (IProperty prop : clicked.func_177228_b().keySet()) {
            if (isDone) break;
            if (prop.func_177701_a().equals("half")) {
                isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
                continue;
            }
            if (prop.func_177701_a().equals("seamless")) {
                isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
                continue;
            }
            if (prop.func_177701_a().equals("axis")) {
                isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
                continue;
            }
            if (!prop.func_177701_a().equals("type") || clickedBlock != Blocks.field_150322_A && clickedBlock != Blocks.field_180395_cM) continue;
            isDone = UtilPlaceBlocks.placeStateOverwrite(worldObj, p, pos, clicked.func_177231_a(prop));
        }
        return isDone;
    }
}

