/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.google.common.io.Files;
import com.lothrazar.cyclicmagic.ModMain;
import com.lothrazar.cyclicmagic.gui.player.InventoryPlayerExtended;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class UtilPlayerInventoryFilestorage {
    private static HashMap<String, InventoryPlayerExtended> playerItems = new HashMap();

    public static void clearPlayerInventory(EntityPlayer player) {
        playerItems.remove(player.getDisplayNameString());
    }

    public static InventoryPlayerExtended getPlayerInventory(EntityPlayer player) {
        if (!playerItems.containsKey(player.getDisplayNameString())) {
            InventoryPlayerExtended inventory = new InventoryPlayerExtended(player);
            playerItems.put(player.getDisplayNameString(), inventory);
        }
        return playerItems.get(player.getDisplayNameString());
    }

    public static void setPlayerInventory(EntityPlayer player, InventoryPlayerExtended inventory) {
        playerItems.put(player.getDisplayNameString(), inventory);
    }

    public static void loadPlayerInventory(EntityPlayer player, File file1, File file2) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            try {
                FileInputStream fileinputstream;
                NBTTagCompound data = null;
                boolean save = false;
                if (file1 != null && file1.exists()) {
                    try {
                        fileinputstream = new FileInputStream(file1);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (file1 == null || !file1.exists() || data == null || data.func_82582_d()) {
                    ModMain.logger.warn("Data not found for " + player.getDisplayNameString() + ". Trying to load backup data.");
                    if (file2 != null && file2.exists()) {
                        try {
                            fileinputstream = new FileInputStream(file2);
                            data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                            fileinputstream.close();
                            save = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (data != null) {
                    InventoryPlayerExtended inventory = new InventoryPlayerExtended(player);
                    inventory.readNBT(data);
                    playerItems.put(player.getDisplayNameString(), inventory);
                    if (save) {
                        UtilPlayerInventoryFilestorage.savePlayerBaubles(player, file1, file2);
                    }
                }
            }
            catch (Exception e) {
                ModMain.logger.error("Error loading player extended inventory");
                e.printStackTrace();
            }
        }
    }

    public static void savePlayerBaubles(EntityPlayer player, File file1, File file2) {
        block11: {
            if (player != null && !player.field_70170_p.field_72995_K) {
                try {
                    if (file1 != null && file1.exists()) {
                        try {
                            Files.copy((File)file1, (File)file2);
                        }
                        catch (Exception e) {
                            ModMain.logger.error("Could not backup old baubles file for player " + player.getDisplayNameString());
                        }
                    }
                    try {
                        if (file1 != null) {
                            InventoryPlayerExtended inventory = UtilPlayerInventoryFilestorage.getPlayerInventory(player);
                            NBTTagCompound data = new NBTTagCompound();
                            inventory.saveNBT(data);
                            FileOutputStream fileoutputstream = new FileOutputStream(file1);
                            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                            fileoutputstream.close();
                        }
                    }
                    catch (Exception e) {
                        ModMain.logger.error("Could not save baubles file for player " + player.getDisplayNameString());
                        e.printStackTrace();
                        if (!file1.exists()) break block11;
                        try {
                            file1.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception1) {
                    ModMain.logger.error("Error saving baubles inventory");
                    exception1.printStackTrace();
                }
            }
        }
    }
}

