/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UtilSearchWorld {
    public static ArrayList<IInventory> findTileEntityInventories(EntityPlayer player, int RADIUS) {
        ArrayList<IInventory> found = new ArrayList<IInventory>();
        int xMin = (int)player.field_70165_t - RADIUS;
        int xMax = (int)player.field_70165_t + RADIUS;
        int yMin = (int)player.field_70163_u - RADIUS;
        int yMax = (int)player.field_70163_u + RADIUS;
        int zMin = (int)player.field_70161_v - RADIUS;
        int zMax = (int)player.field_70161_v + RADIUS;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!(player.field_70170_p.func_175625_s(posCurrent) instanceof IInventory)) continue;
                    found.add((IInventory)player.field_70170_p.func_175625_s(posCurrent));
                }
            }
        }
        return found;
    }

    public static int searchTileInventory(String search, IInventory inventory) {
        int foundQty = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            String invItemName;
            ItemStack invItem = inventory.func_70301_a(slot);
            if (invItem == null || !search.equals(invItemName = invItem.func_82833_r().toLowerCase()) && !search.contains(invItemName) && !invItemName.contains(search)) continue;
            foundQty += invItem.field_77994_a;
        }
        return foundQty;
    }

    public static BlockPos findClosestBlock(EntityPlayer player, Block blockHunt, int RADIUS) {
        BlockPos found = null;
        int xMin = (int)player.field_70165_t - RADIUS;
        int xMax = (int)player.field_70165_t + RADIUS;
        int yMin = (int)player.field_70163_u - RADIUS;
        int yMax = (int)player.field_70163_u + RADIUS;
        int zMin = (int)player.field_70161_v - RADIUS;
        int zMax = (int)player.field_70161_v + RADIUS;
        int distance = 0;
        int distanceClosest = RADIUS * RADIUS;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!player.field_70170_p.func_180495_p(posCurrent).func_177230_c().equals(blockHunt)) continue;
                    if (found == null) {
                        found = posCurrent;
                        continue;
                    }
                    distance = (int)UtilSearchWorld.distanceBetweenHorizontal(player.func_180425_c(), posCurrent);
                    if (distance >= distanceClosest) continue;
                    found = posCurrent;
                    distanceClosest = distance;
                }
            }
        }
        return found;
    }

    public static ArrayList<BlockPos> findBlocks(World world, BlockPos start, Block blockHunt, int RADIUS) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        int xMin = start.func_177958_n() - RADIUS;
        int xMax = start.func_177958_n() + RADIUS;
        int yMin = start.func_177956_o() - RADIUS;
        int yMax = start.func_177956_o() + RADIUS;
        int zMin = start.func_177952_p() - RADIUS;
        int zMax = start.func_177952_p() + RADIUS;
        BlockPos posCurrent = null;
        for (int xLoop = xMin; xLoop <= xMax; ++xLoop) {
            for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                for (int zLoop = zMin; zLoop <= zMax; ++zLoop) {
                    posCurrent = new BlockPos(xLoop, yLoop, zLoop);
                    if (!world.func_180495_p(posCurrent).func_177230_c().equals(blockHunt)) continue;
                    found.add(posCurrent);
                }
            }
        }
        return found;
    }

    public static double distanceBetweenHorizontal(BlockPos start, BlockPos end) {
        int xDistance = Math.abs(start.func_177958_n() - end.func_177958_n());
        int zDistance = Math.abs(start.func_177952_p() - end.func_177952_p());
        return Math.sqrt(xDistance * xDistance + zDistance * zDistance);
    }

    public static double distanceBetweenVertical(BlockPos start, BlockPos end) {
        return Math.abs(start.func_177956_o() - end.func_177956_o());
    }
}

