/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.world.gen;

import com.google.common.base.Predicate;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenEndOre
implements IWorldGenerator {
    private final int MIN_HEIGHT = 5;
    private final int MAX_HEIGHT = 128;
    private WorldGenerator genGold;
    private WorldGenerator genCoal;
    private WorldGenerator genEmerald;
    private WorldGenerator genLapis;
    private WorldGenerator genDiamond;

    public WorldGenEndOre() {
        int blockCount = 8;
        this.genGold = new WorldGenMinable(BlockRegistry.end_redstone_ore.func_176223_P(), blockCount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
        blockCount = 8;
        this.genCoal = new WorldGenMinable(BlockRegistry.end_coal_ore.func_176223_P(), blockCount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
        blockCount = 4;
        this.genEmerald = new WorldGenMinable(BlockRegistry.end_emerald_ore.func_176223_P(), blockCount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
        blockCount = 8;
        this.genLapis = new WorldGenMinable(BlockRegistry.end_lapis_ore.func_176223_P(), blockCount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
        blockCount = 2;
        this.genDiamond = new WorldGenMinable(BlockRegistry.end_diamond_ore.func_176223_P(), blockCount, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 1) {
            int chance = 45;
            this.run(this.genGold, world, random, chunkX * 16, chunkZ * 16, chance, 5, 128);
            chance = 25;
            this.run(this.genCoal, world, random, chunkX * 16, chunkZ * 16, chance, 5, 128);
            chance = 10;
            this.run(this.genEmerald, world, random, chunkX * 16, chunkZ * 16, chance, 5, 128);
            chance = 15;
            this.run(this.genLapis, world, random, chunkX * 16, chunkZ * 16, chance, 5, 128);
            chance = 10;
            this.run(this.genDiamond, world, random, chunkX * 16, chunkZ * 16, chance, 5, 128);
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            generator.func_180709_b(world, rand, pos);
        }
    }
}

