/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.world.gen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenOcean
implements IWorldGenerator {
    public int clayChance = 30;
    public int clayNumBlocks = 50;
    public int dirtChance = 20;
    public int dirtNumBlocks = 20;
    public int sandChance = 45;
    public int sandNumBlocks = 25;
    private WorldGenerator genClay = new WorldGenMinable(Blocks.field_150435_aG.func_176223_P(), this.clayNumBlocks, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150351_n));
    private WorldGenerator genSand = new WorldGenMinable(Blocks.field_150346_d.func_176223_P(), this.dirtNumBlocks, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150351_n));
    private WorldGenerator genDirt = new WorldGenMinable(Blocks.field_150354_m.func_176223_P(), this.sandNumBlocks, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150351_n));
    private final int MIN_HEIGHT = 20;
    private final int MAX_HEIGHT = 128;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.run(this.genClay, world, random, chunkX * 16, chunkZ * 16, this.clayChance, 20, 128);
            this.run(this.genSand, world, random, chunkX * 16, chunkZ * 16, this.sandChance, 20, 128);
            this.run(this.genDirt, world, random, chunkX * 16, chunkZ * 16, this.dirtChance, 20, 128);
        }
    }

    private void run(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int z;
            int y;
            int x = chunk_X + rand.nextInt(16);
            BlockPos pos = new BlockPos(x, y = minHeight + rand.nextInt(heightDiff), z = chunk_Z + rand.nextInt(16));
            Biome biome = world.func_180494_b(pos);
            if (biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && biome != Biomes.field_76776_l) continue;
            generator.func_180709_b(world, rand, pos);
        }
    }
}

