/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.command;

import com.catastrophe573.dimdungeons.DimDungeons;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class CustomTeleporter {
    public static void teleportEntityToDimension(ServerPlayerEntity entity, DimensionType destination, boolean respectMovementFactor, double x, double y, double z, float pitch, float yaw) {
        if (!ForgeHooks.onTravelToDimension((Entity)entity, (DimensionType)destination)) {
            return;
        }
        try {
            ObfuscationReflectionHelper.setPrivateValue(ServerPlayerEntity.class, (Object)entity, (Object)true, (String)"field_184851_cj");
        }
        catch (SecurityException | ObfuscationReflectionHelper.UnableToAccessFieldException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            DimDungeons.LOGGER.info("DIMDUNGEONS ERROR: UNABLE TO SET field invulnerableDimensionChange on Player. Teleporting is about to go wrong!");
        }
        DimensionType dimensiontype = entity.field_71093_bK;
        MinecraftServer minecraftserver = entity.func_184102_h();
        ServerWorld originWorld = minecraftserver.func_71218_a(dimensiontype);
        ServerWorld destinationWorld = minecraftserver.func_71218_a(destination);
        entity.field_71093_bK = destination;
        WorldInfo worldinfo = entity.field_70170_p.func_72912_H();
        entity.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, worldinfo.func_76067_t(), entity.field_71134_c.func_73081_b()));
        entity.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = entity.field_71133_b.func_184103_al();
        playerlist.func_187243_f(entity);
        originWorld.removeEntity((Entity)entity, true);
        entity.revive();
        double d0 = x;
        double d1 = y;
        double d2 = z;
        float f = pitch;
        float f1 = yaw;
        if (respectMovementFactor) {
            double moveFactor = originWorld.func_201675_m().getMovementFactor() / destinationWorld.func_201675_m().getMovementFactor();
            d0 *= moveFactor;
            d2 *= moveFactor;
        }
        entity.func_70012_b(d0, d1, d2, f1, f);
        entity.field_71135_a.func_147364_a(x, y, z, f1, f);
        double d7 = Math.min(-2.9999872E7, destinationWorld.func_175723_af().func_177726_b() + 16.0);
        double d4 = Math.min(-2.9999872E7, destinationWorld.func_175723_af().func_177736_c() + 16.0);
        double d5 = Math.min(2.9999872E7, destinationWorld.func_175723_af().func_177728_d() - 16.0);
        double d6 = Math.min(2.9999872E7, destinationWorld.func_175723_af().func_177733_e() - 16.0);
        d0 = MathHelper.func_151237_a((double)d0, (double)d7, (double)d5);
        d2 = MathHelper.func_151237_a((double)d2, (double)d4, (double)d6);
        entity.func_70012_b(d0, d1, d2, f1, f);
        entity.field_71135_a.func_147364_a(d0, d1, d2, f1, f);
        entity.func_70029_a((World)destinationWorld);
        destinationWorld.func_217447_b(entity);
        entity.field_71135_a.func_147364_a(d0, d1, d2, f1, f);
        entity.field_71134_c.func_73080_a(destinationWorld);
        entity.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(entity.field_71075_bZ));
        playerlist.func_72354_b(entity, destinationWorld);
        playerlist.func_72385_f(entity);
        for (EffectInstance effectinstance : entity.func_70651_bq()) {
            entity.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effectinstance));
        }
        entity.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        entity.func_195068_e(0);
        entity.func_71118_n();
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)entity, (DimensionType)dimensiontype, (DimensionType)destination);
    }
}

