/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.dimension;

import com.catastrophe573.dimdungeons.biome.BiomeProviderDungeon;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonChunkGenerator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeDimension;

public class DungeonDimension
extends Dimension {
    public DungeonDimension(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
    }

    public ChunkGenerator<? extends GenerationSettings> func_186060_c() {
        BiomeProviderDungeon biomeProvider = new BiomeProviderDungeon();
        ChunkGeneratorType gen = new ChunkGeneratorType(DungeonChunkGenerator::new, true, OverworldGenSettings::new);
        OverworldGenSettings gensettings = new OverworldGenSettings();
        return gen.create(this.field_76579_a, (BiomeProvider)biomeProvider, (GenerationSettings)gensettings);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return MusicTicker.MusicType.GAME;
    }

    public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return IForgeDimension.SleepResult.DENY;
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return false;
    }

    public DimensionType getRespawnDimension(ServerPlayerEntity player) {
        return player.getSpawnDimension();
    }

    public boolean canMineBlock(PlayerEntity player, BlockPos pos) {
        Block block = this.getWorld().func_180495_p(pos).func_177230_c();
        if (block.func_203417_a(BlockTags.field_200152_g) || block.func_203417_a(BlockTags.field_212186_k)) {
            return true;
        }
        if (block == Blocks.field_150442_at || block.func_203417_a(BlockTags.field_200027_d) || block == Blocks.field_150383_bp) {
            return true;
        }
        if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_222422_lK) {
            return true;
        }
        if (block == BlockRegistrar.block_portal_keyhole) {
            return true;
        }
        return block.getRegistryName().func_110624_b() == "gravestones";
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return null;
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        return null;
    }

    public boolean func_76567_e() {
        return false;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)-0.20833333333333334);
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public boolean func_191066_m() {
        return true;
    }

    public boolean func_76569_d() {
        return false;
    }

    public boolean func_177495_o() {
        return false;
    }

    public boolean func_177500_n() {
        return false;
    }

    public Biome getBiome(BlockPos pos) {
        return this.getWorld().getBiomeBody(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    public float getSunBrightness(float partialTicks) {
        return this.getWorld().getSunBrightnessBody(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getSkyColor(BlockPos cameraPos, float partialTicks) {
        return this.getWorld().getSkyColorBody(cameraPos, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        return this.getWorld().getCloudColorBody(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        return new Vec3d(0.75, 0.75, 0.95);
    }

    public float func_76571_f() {
        return 199.0f;
    }
}

