/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.item;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemPortalKey
extends Item {
    public static final String REG_NAME = "item_portal_key";
    public static final String NBT_KEY_ACTIVATED = "key_activated";
    public static final String NBT_KEY_DESTINATION_X = "dest_x";
    public static final String NBT_KEY_DESTINATION_Z = "dest_z";
    public static final String NBT_NAME_TYPE = "name_type";
    public static final String NBT_NAME_PART_1 = "name_part_1";
    public static final String NBT_NAME_PART_2 = "name_part_2";
    public static final int BLOCKS_APART_PER_DUNGEON = 256;
    public static final int RANDOM_COORDINATE_RANGE = 8192;
    public static final float ENTRANCE_OFFSET_X = 136.0f;
    public static final float ENTRANCE_OFFSET_Z = 188.5f;

    public ItemPortalKey() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.setRegistryName("dimdungeons", REG_NAME);
        this.func_185043_a(new ResourceLocation("dimdungeons", "keytype"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
                if (ItemPortalKey.this.isActivated(stack)) {
                    if (ItemPortalKey.this.getWarpZ(stack) < 0.0f) {
                        return 0.2f;
                    }
                    return 0.1f;
                }
                return 0.0f;
            }
        });
    }

    public int getKeyLevel(ItemStack stack) {
        if (!this.isActivated(stack)) {
            return 0;
        }
        if (this.getWarpZ(stack) < 0.0f) {
            return 2;
        }
        return 1;
    }

    public void activateKey(ItemStack stack) {
        CompoundNBT data = new CompoundNBT();
        data.func_74757_a(NBT_KEY_ACTIVATED, true);
        int destX = field_77697_d.nextInt(8192);
        int destZ = field_77697_d.nextInt(8192);
        data.func_74768_a(NBT_KEY_DESTINATION_X, destX);
        data.func_74768_a(NBT_KEY_DESTINATION_Z, destZ);
        int nameType = field_77697_d.nextInt(3);
        data.func_74768_a(NBT_NAME_TYPE, nameType);
        if (nameType == 0 || nameType == 1) {
            data.func_74768_a(NBT_NAME_PART_1, field_77697_d.nextInt(32));
            data.func_74768_a(NBT_NAME_PART_2, field_77697_d.nextInt(32));
        } else {
            data.func_74768_a(NBT_NAME_PART_1, field_77697_d.nextInt(20));
            data.func_74768_a(NBT_NAME_PART_2, field_77697_d.nextInt(32));
        }
        stack.func_77982_d(data);
    }

    public void activateKeyLevel2(ItemStack stack) {
        CompoundNBT data = new CompoundNBT();
        data.func_74757_a(NBT_KEY_ACTIVATED, true);
        int destX = field_77697_d.nextInt(8192);
        int destZ = field_77697_d.nextInt(8192);
        data.func_74768_a(NBT_KEY_DESTINATION_X, destX);
        data.func_74768_a(NBT_KEY_DESTINATION_Z, destZ * -1);
        data.func_74768_a(NBT_NAME_TYPE, 3);
        data.func_74768_a(NBT_NAME_PART_1, field_77697_d.nextInt(20));
        data.func_74768_a(NBT_NAME_PART_2, field_77697_d.nextInt(12));
        stack.func_77982_d(data);
    }

    public boolean isActivated(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_KEY_ACTIVATED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT itemData;
        if (stack.func_77942_o() && (itemData = stack.func_77978_p()).func_74764_b(NBT_KEY_ACTIVATED)) {
            int nameType = itemData.func_74764_b(NBT_NAME_TYPE) ? itemData.func_74762_e(NBT_NAME_TYPE) : 0;
            int word_index_1 = itemData.func_74764_b(NBT_NAME_PART_1) ? itemData.func_74762_e(NBT_NAME_PART_1) : 2;
            int word_index_2 = itemData.func_74764_b(NBT_NAME_PART_2) ? itemData.func_74762_e(NBT_NAME_PART_2) : 1;
            String retval = "";
            if (nameType == 0) {
                String start = I18n.func_135052_a((String)"npart.dimdungeons.struct_1", (Object[])new Object[0]);
                String preposition = I18n.func_135052_a((String)"npart.dimdungeons.struct_2", (Object[])new Object[0]);
                String noun1 = I18n.func_135052_a((String)("npart.dimdungeons.noun_" + word_index_1), (Object[])new Object[0]);
                String noun2 = I18n.func_135052_a((String)("npart.dimdungeons.noun_" + word_index_2), (Object[])new Object[0]);
                retval = word_index_1 == word_index_2 ? start + " " + noun1 : start + " " + noun1 + " " + preposition + " " + noun2;
            } else if (nameType == 1) {
                String start = I18n.func_135052_a((String)"npart.dimdungeons.struct_3", (Object[])new Object[0]);
                String preposition = I18n.func_135052_a((String)"npart.dimdungeons.struct_4", (Object[])new Object[0]);
                String noun1 = I18n.func_135052_a((String)("npart.dimdungeons.noun_" + word_index_1), (Object[])new Object[0]);
                String noun2 = I18n.func_135052_a((String)("npart.dimdungeons.noun_" + word_index_2), (Object[])new Object[0]);
                retval = word_index_1 == word_index_2 ? start + " " + noun1 : start + " " + noun1 + " " + preposition + " " + noun2;
            } else if (nameType == 2) {
                String start = I18n.func_135052_a((String)"npart.dimdungeons.struct_5", (Object[])new Object[0]);
                String preposition = I18n.func_135052_a((String)"npart.dimdungeons.struct_6", (Object[])new Object[0]);
                String place = I18n.func_135052_a((String)("npart.dimdungeons.place_" + word_index_1), (Object[])new Object[0]);
                String noun = I18n.func_135052_a((String)("npart.dimdungeons.noun_" + word_index_2), (Object[])new Object[0]);
                retval = start + " " + place + " " + preposition + " " + noun;
            } else if (nameType == 3) {
                String start = I18n.func_135052_a((String)"npart.dimdungeons.struct_7", (Object[])new Object[0]);
                String place = I18n.func_135052_a((String)("npart.dimdungeons.place_" + word_index_1), (Object[])new Object[0]);
                String largeness = I18n.func_135052_a((String)("npart.dimdungeons.large_" + word_index_2), (Object[])new Object[0]);
                retval = start + " " + largeness + " " + place;
            }
            return new StringTextComponent(retval);
        }
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[0]);
    }

    public float getWarpX(ItemStack stack) {
        CompoundNBT itemData;
        if (stack != null && !stack.func_190926_b() && (itemData = stack.func_77978_p()) != null && itemData.func_74764_b(NBT_KEY_DESTINATION_X)) {
            return (float)(itemData.func_74762_e(NBT_KEY_DESTINATION_X) * 256) + 136.0f;
        }
        return -1.0f;
    }

    public float getWarpZ(ItemStack stack) {
        CompoundNBT itemData;
        if (stack != null && !stack.func_190926_b() && (itemData = stack.func_77978_p()) != null && itemData.func_74764_b(NBT_KEY_DESTINATION_Z)) {
            float z = (float)(itemData.func_74762_e(NBT_KEY_DESTINATION_Z) * 256) + 188.5f;
            return z;
        }
        return -1.0f;
    }

    public ActionResultType func_195939_a(ItemUseContext parameters) {
        World worldIn = parameters.func_195991_k();
        BlockPos pos = parameters.func_195995_a();
        Direction facing = parameters.func_196000_l();
        double hitX = parameters.func_221532_j().func_82615_a();
        double hitZ = parameters.func_221532_j().func_82616_c();
        BlockState iblockstate = worldIn.func_180495_p(pos);
        ItemStack itemstack = parameters.func_195996_i();
        hitX = Math.abs((double)((int)hitX) - hitX);
        hitZ = Math.abs((double)((int)hitZ) - hitZ);
        if (worldIn.func_180495_p(pos) != null) {
            if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150378_br) {
                boolean isFilled = (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)EndPortalFrameBlock.field_176507_b);
                if (hitX > (double)0.3f && hitX < (double)0.7f && hitZ > (double)0.3f && hitZ < (double)0.8f) {
                    if (!isFilled) {
                        if (facing == Direction.UP) {
                            if (this.isActivated(itemstack)) {
                                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187770_dm, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            } else {
                                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_206938_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                if (pos.func_177958_n() == 0 && pos.func_177952_p() == 0) {
                                    this.activateKeyLevel2(itemstack);
                                } else {
                                    this.activateKey(itemstack);
                                }
                                for (int i = 0; i < 32; ++i) {
                                    double d0 = (float)pos.func_177958_n() + 0.5f;
                                    double d1 = (float)pos.func_177956_o() + 0.8f;
                                    double d2 = (float)pos.func_177952_p() + 0.5f;
                                    double xspeed = (double)field_77697_d.nextFloat() * 0.04 * (double)(field_77697_d.nextBoolean() ? 1 : -1);
                                    double yspeed = (double)field_77697_d.nextFloat() * 0.125;
                                    double zspeed = (double)field_77697_d.nextFloat() * 0.04 * (double)(field_77697_d.nextBoolean() ? 1 : -1);
                                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197629_v, d0, d1, d2, xspeed, yspeed, zspeed);
                                }
                            }
                        }
                    } else {
                        worldIn.func_180501_a(pos, (BlockState)iblockstate.func_206870_a((IProperty)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(false)), 2);
                        worldIn.func_175666_e(pos, Blocks.field_150378_br);
                        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_193777_bb, SoundCategory.BLOCKS, 1.5f, 1.0f);
                        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.4f, 1.5f);
                        for (int i = 0; i < 32; ++i) {
                            double d0 = (float)pos.func_177958_n() + 0.5f;
                            double d1 = (float)pos.func_177956_o() + 0.8f;
                            double d2 = (float)pos.func_177952_p() + 0.5f;
                            double xspeed = (double)field_77697_d.nextFloat() * 0.08 * (double)(field_77697_d.nextBoolean() ? 1 : -1);
                            double yspeed = (double)field_77697_d.nextFloat() * 0.4;
                            double zspeed = (double)field_77697_d.nextFloat() * 0.08 * (double)(field_77697_d.nextBoolean() ? 1 : -1);
                            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, xspeed, yspeed, zspeed);
                        }
                    }
                } else {
                    worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187565_bO, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187565_bO, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return ActionResultType.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return false;
    }
}

