/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.ai;

import com.gw.dm.entity.EntityEldermob;
import com.gw.dm.util.DungeonMobsHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class AIEldermobMove
extends EntityAIBase {
    private final EntityEldermob owner;
    private final double rate;
    private double targetx;
    private double targety;
    private double targetz;
    private double dtx;
    private double dty;
    private double dtz;
    private int cooldown;

    public AIEldermobMove(EntityEldermob it, double speed) {
        this.owner = it;
        this.rate = speed;
        Random random = this.owner.func_70681_au();
        this.dtx = random.nextDouble() * 8.0 - 4.0;
        this.dty = random.nextDouble() * 4.0;
        this.dtz = random.nextDouble() * 8.0 - 4.0;
        this.targetx = this.owner.field_70165_t + this.dtx;
        this.targety = this.owner.field_70163_u + this.dty;
        this.targetz = this.owner.field_70161_v + this.dtz;
    }

    public boolean func_75250_a() {
        boolean out;
        if (this.cooldown < 2) {
            this.cooldown = 2;
        }
        boolean bl = out = this.owner.func_70681_au().nextInt(--this.cooldown) < 1 && this.needNewTarget();
        if (out) {
            this.cooldown = 20 + this.owner.func_70681_au().nextInt(20) - DungeonMobsHelper.getDifficulty(this.owner.field_70170_p) * 5;
        }
        return out;
    }

    public boolean func_75253_b() {
        return false;
    }

    public boolean needNewTarget() {
        double dz;
        double dy;
        EntityMoveHelper helper = this.owner.func_70605_aq();
        if (helper.func_75640_a()) {
            return true;
        }
        double dx = helper.func_179917_d() - this.owner.field_70165_t;
        double dist = dx * dx + (dy = helper.func_179919_e() - this.owner.field_70163_u) * dy + (dz = helper.func_179918_f() - this.owner.field_70161_v) * dz;
        return dist < 1.0 || dist > 432.0 || ((EldermobMover)helper).blocked;
    }

    public void func_75249_e() {
        Random random = this.owner.func_70681_au();
        if (((EldermobMover)this.owner.func_70605_aq()).blocked) {
            this.dtx = random.nextDouble() * 48.0 - 24.0;
            this.dty = this.owner.field_70163_u > 192.0 ? -(random.nextDouble() * 24.0 + 24.0) : random.nextDouble() * 24.0 - 12.0;
            this.dtz = random.nextDouble() * 48.0 - 24.0;
        } else if (random.nextBoolean()) {
            double change = random.nextDouble();
            double stable = change - 1.0;
            this.dtx = this.dtx * stable + change * (random.nextDouble() * 8.0 - 4.0);
            this.dty = this.dty * stable + change * (random.nextDouble() * 8.0 - 4.0);
            this.dtz = this.dtz * stable + change * (random.nextDouble() * 8.0 - 4.0);
        }
        this.targetx = this.owner.field_70165_t + this.dtx;
        this.targety = this.owner.field_70163_u + this.dty;
        this.targetz = this.owner.field_70161_v + this.dtz;
        if (this.isTooFar()) {
            this.targetx = this.owner.field_70165_t - this.dtx;
            this.targety = this.owner.field_70163_u - this.dty;
            this.targetz = this.owner.field_70161_v - this.dtz;
        }
        this.owner.func_70605_aq().func_75642_a(this.targetx, this.targety, this.targetz, this.rate);
    }

    public AIEldermobMove startingMove() {
        this.owner.func_70605_aq().func_75642_a(this.owner.field_70165_t, this.owner.field_70163_u + this.owner.func_70681_au().nextDouble() * 8.0 + 4.0, this.owner.field_70161_v, this.rate);
        this.cooldown = 2;
        return this;
    }

    private boolean isTooFar() {
        EntityLivingBase victim = this.owner.func_70638_az();
        if (victim == null || victim.field_70128_L) {
            return false;
        }
        double dx = victim.field_70165_t - this.targetx;
        double dy = victim.field_70163_u - this.targety;
        double dz = victim.field_70161_v - this.targetz;
        double dist = dx * dx + dy * dy + dz * dz;
        return dist > 1024.0;
    }

    private boolean atTarget() {
        EntityMoveHelper helper = this.owner.func_70605_aq();
        double dx = this.targetx - this.owner.field_70165_t;
        double dy = this.targety - this.owner.field_70163_u;
        double dz = this.targetz - this.owner.field_70161_v;
        return dx * dx + dy * dy + dz * dz < 1.0;
    }

    void setTarget(double toX, double toY, double toZ) {
        this.targetx = this.owner.field_70165_t + toX;
        this.targety = this.owner.field_70163_u + toY;
        this.targetz = this.owner.field_70161_v + toZ;
    }

    void callMoveHelper() {
        this.owner.func_70605_aq().func_75642_a(this.targetx, this.targety, this.targetz, this.rate);
    }

    public static class EldermobMover
    extends EntityMoveHelper {
        EntityEldermob owner;
        boolean blocked;

        public EldermobMover(EntityEldermob eldermob) {
            super((EntityLiving)eldermob);
            this.owner = eldermob;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.blocked = false;
                double dx = this.field_75646_b - this.owner.field_70165_t;
                double dy = this.field_75647_c - this.owner.field_70163_u;
                double dz = this.field_75644_d - this.owner.field_70161_v;
                double dist = dx * dx + dy * dy + dz * dz;
                if (this.isColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, dist)) {
                    this.blocked = true;
                } else {
                    double diffEffect;
                    dist = Math.sqrt(dist);
                    switch (this.owner.field_70170_p.func_175659_aa()) {
                        case EASY: {
                            diffEffect = 0.03;
                            break;
                        }
                        case HARD: {
                            diffEffect = 0.035;
                            break;
                        }
                        default: {
                            diffEffect = 0.04;
                        }
                    }
                    double ra = this.field_75645_e / dist * diffEffect;
                    this.owner.field_70159_w += (dx *= ra);
                    this.owner.field_70181_x += (dy *= ra);
                    this.owner.field_70179_y += (dz *= ra);
                    if (this.owner.func_70638_az() != null) {
                        dx = this.field_75646_b - this.owner.func_70638_az().field_70165_t;
                        dz = this.field_75644_d - this.owner.func_70638_az().field_70161_v;
                        dist = Math.sqrt(dx * dx + dz * dz);
                        this.owner.field_70177_z = (float)(Math.toDegrees(MathHelper.func_181159_b((double)(dz /= dist), (double)(dx /= dist))) + 90.0);
                    } else if (dist > 1.5) {
                        this.owner.field_70177_z = (float)(Math.toDegrees(MathHelper.func_181159_b((double)dz, (double)dx)) - 90.0);
                    }
                }
            } else {
                super.func_75641_c();
            }
        }

        public boolean isColliding(double dx, double dy, double dz, double dist) {
            double dx0 = (dx - this.owner.field_70165_t) / dist;
            double dy0 = (dy - this.owner.field_70163_u) / dist;
            double dz0 = (dz - this.owner.field_70161_v) / dist;
            AxisAlignedBB axisalignedbb = this.owner.func_174813_aQ();
            int i = 1;
            while ((double)i < dist) {
                if (!this.owner.field_70170_p.func_184144_a((Entity)this.owner, axisalignedbb = axisalignedbb.func_72317_d(dx0, dy0, dz0)).isEmpty()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

