/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.EntityDungeonFlying;
import com.gw.dm.ai.AIEldermobMove;
import com.gw.dm.entity.IBeMagicMob;
import com.gw.dm.projectile.EntityCloudGenerator;
import com.gw.dm.projectile.EntityEldermobBall;
import com.gw.dm.projectile.EntityFireCloudGenerator;
import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;

public class EntityEldermob
extends EntityDungeonFlying
implements IMob,
IRangedAttackMob,
IBeMagicMob {
    private static final int SD = 0x100000;
    private static String mobName = "dungeonmobs:dmeldermob";
    private static PotionEffect poison = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("poison")), 300, 0);

    public EntityEldermob(World worldIn) {
        super(worldIn);
        this.field_70765_h = new AIEldermobMove.EldermobMover(this);
        this.func_70105_a(2.0f, 2.0f);
        this.field_70728_aV = 65;
        this.field_70178_ae = true;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.field_70170_p.field_72995_K) {
            double dx = target.field_70165_t - this.field_70165_t;
            double dy = target.field_70163_u + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double dz = target.field_70161_v - this.field_70161_v;
            int which = ConfigHandler.fireClouds ? this.field_70146_Z.nextInt(3) : this.field_70146_Z.nextInt(2);
            if (which == 2 && target.func_70045_F()) {
                --which;
            }
            if (which == 1 && target.func_70662_br()) {
                --which;
            }
            switch (which) {
                case 0: {
                    EntityEldermobBall ball = new EntityEldermobBall(this.field_70170_p, (EntityLivingBase)this);
                    ball.func_70186_c(dx, dy, dz, 1.2f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)ball);
                    break;
                }
                case 1: {
                    dy = target.field_70163_u - this.field_70163_u - (double)(this.field_70131_O / 2.0f);
                    EntityCloudGenerator ball = new EntityCloudGenerator(this.field_70170_p, (EntityLivingBase)this, poison);
                    ball.func_70186_c(dx, dy, dz, 1.2f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)ball);
                    break;
                }
                case 2: {
                    EntityFireCloudGenerator ball = new EntityFireCloudGenerator(this.field_70170_p, (EntityLivingBase)this);
                    ball.func_70186_c(dx, dy, dz, 1.2f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)ball);
                    break;
                }
                default: {
                    EntityEldermobBall ball = new EntityEldermobBall(this.field_70170_p, (EntityLivingBase)this);
                    ball.func_70186_c(dx, dy, dz, 1.2f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)ball);
                }
            }
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_180799_ab() {
        return false;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextBoolean()) {
            return AudioHandler.entityEldermobA1;
        }
        return AudioHandler.entityEldermobA2;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return AudioHandler.entityEldermobA3;
    }

    protected SoundEvent func_184615_bR() {
        return AudioHandler.entityEldermobA3;
    }

    public int func_70627_aG() {
        return 100;
    }

    protected float func_70599_aP() {
        return 2.5f;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        super.func_70071_h_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(66.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, (double)0.3f, 10, 50, 40.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIEldermobMove(this, 1.0).startingMove());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w instanceof WorldProviderEnd && this.deepEnoughInEnd() && this.field_70146_Z.nextInt(24) == 0) {
            return super.func_70601_bi();
        }
        if (ConfigHandler.outerThingIg && !(this.field_70170_p.field_73011_w instanceof WorldProviderEnd)) {
            return super.func_70601_bi();
        }
        if (DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (this.field_70170_p.func_175710_j(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (this.field_70163_u > 32.0 && !this.ignoreHeight) {
            return false;
        }
        return super.func_70601_bi();
    }

    private boolean deepEnoughInEnd() {
        return ConfigHandler.outerThingEI || this.field_70165_t * this.field_70165_t + this.field_70161_v * this.field_70161_v > 1048576.0;
    }

    protected void func_70665_d(DamageSource source, float damageAmount) {
        if (source.func_76347_k() || source.func_82725_o() || source.func_76346_g() == this) {
            return;
        }
        super.func_70665_d(source, damageAmount);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k() || source.func_82725_o()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity == this) {
            return false;
        }
        if (entity != null && entity instanceof EntityLivingBase && !(entity instanceof EntityEldermob) && (this.func_70638_az() == null || (float)this.field_70146_Z.nextInt(20) < amount || !this.func_70685_l((Entity)this.func_70638_az()))) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var2;
        this.func_145779_a(Item.func_150898_a((Block)Blocks.field_180399_cE), this.field_70146_Z.nextInt(2) + par2);
        this.func_145779_a(Items.field_151061_bv, this.field_70146_Z.nextInt(2) + par2);
        if (par1 && (var2 = this.field_70146_Z.nextInt(DungeonMobsHelper.getDifficulty(this.field_70170_p) + 2)) == 0) {
            ItemStack myBook = new ItemStack(Items.field_151134_bR, 1);
            DungeonMobsHelper.addEnchantment(myBook, this.field_70146_Z);
            EntityItem itemEnt = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, myBook);
            this.field_70170_p.func_72838_d((Entity)itemEnt);
        }
    }
}

