/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.EntityDungeonFlying;
import com.gw.dm.ai.AIAngelAttack;
import com.gw.dm.ai.AIAngelWander;
import com.gw.dm.ai.TaskAngelAgroOnPlayer;
import com.gw.dm.entity.IBeMagicMob;
import com.gw.dm.projectile.EntityLightball;
import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;

public class EntityFallenAngel
extends EntityDungeonFlying
implements IMob,
IRangedAttackMob,
IBeMagicMob {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityFallenAngel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static String mobName = "dungeonmobs:dmfallenangel";

    public EntityFallenAngel(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.75f, 1.95f);
        this.field_70765_h = new AIAngelWander.AngelicMoveHelper(this);
        this.field_70728_aV = 65;
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        AIAngelWander motion = new AIAngelWander(this, 1.0);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAngelAttack(motion, this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)motion);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new TaskAngelAgroOnPlayer(this, 24.0));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        super.func_70088_a();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(72.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(7.0);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.field_70170_p.field_72995_K) {
            double dx = target.field_70165_t - this.field_70165_t;
            double dy = target.field_70163_u + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double dz = target.field_70161_v - this.field_70161_v;
            EntityLightball ball = new EntityLightball(this.field_70170_p, (EntityLivingBase)this);
            ball.func_70186_c(dx, dy, dz, 1.2f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)ball);
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (entity != null && entity instanceof EntityLivingBase && (this.func_70638_az() == null || (float)this.field_70146_Z.nextInt(20) < amount || !this.func_70685_l((Entity)this.func_70638_az()))) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70686_a(Class cls) {
        return true;
    }

    public int func_70627_aG() {
        return 60;
    }

    protected SoundEvent func_184639_G() {
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                return AudioHandler.entityFallenSing1;
            }
            case 1: {
                return AudioHandler.entityFallenSing2;
            }
            case 2: {
                return AudioHandler.entityFallenSing3;
            }
            case 3: {
                return AudioHandler.entityFallenSing4;
            }
        }
        return AudioHandler.entityFallenSing1;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected float func_70599_aP() {
        return 2.5f;
    }

    @Nullable
    protected Item func_146068_u() {
        return Item.func_111206_d((String)"gold_ingot");
    }

    @Override
    public boolean func_70601_bi() {
        if (ConfigHandler.fallenAngelIg || this.field_70170_p.field_73011_w instanceof WorldProviderHell || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (this.field_70170_p.func_175710_j(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (this.field_70163_u > 32.0 && !this.ignoreHeight) {
            return false;
        }
        return super.func_70601_bi();
    }

    public void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        Item item = Item.func_111206_d((String)"glowstone_dust");
        int n = this.field_70146_Z.nextInt(5) + 3 + lootingModifier;
        for (int i = 0; i < n; ++i) {
            this.func_145779_a(item, 1);
        }
        if (this.field_70146_Z.nextInt(DungeonMobsHelper.getDifficulty(this.field_70170_p)) == 0) {
            ItemStack sword = new ItemStack(Items.field_151010_B);
            sword.func_77966_a(Enchantment.func_180305_b((String)"smite"), this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(3) + 1);
        }
        super.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public boolean areArmsUp() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }
}

