/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.DungeonMobsDamageSource;
import com.gw.dm.EntityDungeonMob;
import com.gw.dm.entity.IBeMagicMob;
import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGhost
extends EntityDungeonMob
implements IBeMagicMob {
    private static String mobName = "dungeonmobs:dmghost";

    public EntityGhost(World worldIn) {
        super(worldIn);
        this.field_70728_aV = 20;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * (double)ConfigHandler.damagex + (double)ConfigHandler.damageplus);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (ConfigHandler.ghostIg || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (this.field_70163_u > 36.0 && !this.ignoreHeight) {
            return false;
        }
        return super.func_70601_bi();
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.func_82725_o() || damageSrc.func_180136_u() || damageSrc == DungeonMobsDamageSource.LIGHT_BALL) {
            super.func_70665_d(damageSrc, damageAmount);
            return;
        }
        if (damageSrc.func_76347_k() || damageSrc.func_76346_g() instanceof IBeMagicMob) {
            super.func_70665_d(damageSrc, damageAmount / 2.0f);
            return;
        }
        Entity attacker = damageSrc.func_76346_g();
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            ItemStack equipt = (ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c);
            if (equipt.func_77948_v()) {
                short highest = 0;
                NBTTagList enchants = equipt.func_77986_q();
                for (NBTBase tag : enchants) {
                    NBTTagCompound compound = (NBTTagCompound)tag;
                    if (compound.func_74765_d("id") == 17) {
                        super.func_70665_d(damageSrc, damageAmount);
                        return;
                    }
                    short tmp = compound.func_74765_d("lvl");
                    if (tmp <= highest) continue;
                    highest = tmp;
                }
                super.func_70665_d(damageSrc, Math.min(damageAmount + (float)this.field_70146_Z.nextInt(2), (float)highest));
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity attacker = source.func_76346_g();
        EntityLivingBase target = this.func_70638_az();
        if ((target == null || target.field_70128_L) && attacker instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)attacker);
        }
        if (this.canHarmGhost(source)) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    public boolean canHarmGhost(DamageSource damageSrc) {
        Entity attacker = damageSrc.func_76346_g();
        if (damageSrc.func_82725_o() || damageSrc.func_180136_u() || damageSrc == DungeonMobsDamageSource.LIGHT_BALL || damageSrc.func_76347_k() || attacker instanceof IBeMagicMob) {
            return true;
        }
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            ItemStack equipt = (ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c);
            if (equipt.func_77948_v()) {
                return true;
            }
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextBoolean()) {
            return AudioHandler.entityGhostAmbient1;
        }
        return AudioHandler.entityGhostAmbient2;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return AudioHandler.entityGhostHurt;
    }

    protected SoundEvent func_184615_bR() {
        return AudioHandler.entityGhostDeath;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72935_r() && this.func_70013_c() > 0.5f && this.field_70170_p.func_175678_i(this.func_180425_c())) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_70099_a(new ItemStack(Items.field_151100_aR, this.field_70146_Z.nextInt(4) + par2, 15), 0.0f);
        if (par1) {
            if (par2 > 2) {
                this.func_145779_a(Items.field_151114_aO, this.field_70146_Z.nextInt(2));
                this.func_145779_a(Items.field_151073_bk, this.field_70146_Z.nextInt(par2));
            } else {
                this.func_145779_a(Items.field_151073_bk, this.field_70146_Z.nextInt(2));
            }
        } else {
            this.func_145779_a(Items.field_151073_bk, this.field_70146_Z.nextInt(2));
        }
    }
}

