/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.EntityDungeonMob;
import com.gw.dm.ai.EntityAIFollowTwin;
import com.gw.dm.ai.EntityAIMonsterPanic;
import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityLizalfos
extends EntityDungeonMob {
    private static final List<LocOffset> locations = new ArrayList<LocOffset>();
    private static String mobName = "dungeonmobs:lizalfos";
    public boolean myTwinIsDead = false;
    public boolean goodToGo = false;
    public boolean isRetreating = false;
    public boolean hasRetreated = false;
    private int twinID = -1;
    private int twinEntityID;
    private boolean isTwin = false;
    private boolean ignoreHeight = false;
    private EntityLizalfos myTwin = null;
    private WeakReference<EntityLizalfos> myTwinWeak;
    private boolean isLeaping;
    private int runTimer;
    private EntityAIFollowTwin followTwin;
    private EntityAIAttackMelee attack;
    private EntityAIAvoidEntity retreat;
    private EntityAIMonsterPanic panic;
    private boolean newSpawn = true;
    private EntityAIHurtByTarget revenge;
    private EntityAINearestAttackableTarget target;

    public EntityLizalfos(World par1World) {
        super(par1World);
        this.func_70105_a(1.4f, 2.5f);
        this.field_70728_aV = 30;
        this.runTimer = 0;
        this.followTwin = new EntityAIFollowTwin(this, 1.0f);
        this.attack = new EntityAIAttackMelee((EntityCreature)this, 1.0, false);
        this.retreat = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 24.0f, 1.0, 0.5);
        this.panic = new EntityAIMonsterPanic(this, 1.0f);
        this.revenge = new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]);
        this.target = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.attack);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.revenge);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.target);
    }

    private EntityLizalfos(World world, EntityLizalfos twin, double x, double y, double z) {
        this(world);
        this.newSpawn = false;
        twin.setTwin(this);
        this.setTwin(twin);
        this.isTwin = true;
        this.twinEntityID = twin.func_145782_y();
        twin.twinEntityID = this.func_145782_y();
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.setIsTwin(true);
        this.setTwinID(this.twinID);
    }

    public static void initLocations() {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                if (i == 0 || j == 0) continue;
                locations.add(new LocOffset(i, j));
            }
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0 * (double)ConfigHandler.damagex + (double)ConfigHandler.damageplus);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
    }

    public int func_70627_aG() {
        return 80;
    }

    protected SoundEvent func_184639_G() {
        if (this.isTwin()) {
            return AudioHandler.entityLizalfosAmbient1;
        }
        return AudioHandler.entityLizalfosAmbient2;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return AudioHandler.entityLizalfosHurt;
    }

    protected SoundEvent func_184615_bR() {
        return AudioHandler.entityLizalfosDeath;
    }

    public int getTwinID() {
        return this.twinID;
    }

    public boolean isTwin() {
        return this.isTwin;
    }

    public void setIsTwin(boolean foo) {
        this.isTwin = foo;
    }

    public void setTwinID(int i) {
        this.twinID = i;
    }

    public void setTwin(EntityLizalfos foo) {
        this.myTwinWeak = new WeakReference<EntityLizalfos>(foo);
    }

    public EntityLizalfos getTwin() {
        if (this.myTwinWeak != null) {
            return (EntityLizalfos)((Object)this.myTwinWeak.get());
        }
        return null;
    }

    public void killTwin() {
        this.myTwinIsDead = true;
        this.myTwinWeak = null;
    }

    public boolean func_70601_bi() {
        if (this.isTwin()) {
            return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), null).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        }
        if (ConfigHandler.lizalfosIg || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (this.field_70170_p.func_175710_j(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (this.field_70163_u > 32.0 && !this.ignoreHeight) {
            return false;
        }
        return super.func_70601_bi();
    }

    public boolean isTwinDead() {
        return this.myTwinIsDead;
    }

    public void func_70106_y() {
        if (this.myTwin != null && this.myTwinWeak != null && !this.isTwinDead()) {
            ((EntityLizalfos)((Object)this.myTwinWeak.get())).killTwin();
        }
        super.func_70106_y();
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("twinID", this.twinID);
        par1NBTTagCompound.func_74757_a("isTwin", this.isTwin);
        par1NBTTagCompound.func_74757_a("twinDead", this.myTwinIsDead);
        par1NBTTagCompound.func_74757_a("hasFled", this.hasRetreated);
        par1NBTTagCompound.func_74757_a("isRunning", this.isRetreating);
        par1NBTTagCompound.func_74768_a("runTimer", this.runTimer);
        par1NBTTagCompound.func_74757_a("newSpawn", this.newSpawn);
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.twinID = par1NBTTagCompound.func_74762_e("twinID");
        this.isTwin = par1NBTTagCompound.func_74767_n("isTwin");
        this.myTwinIsDead = par1NBTTagCompound.func_74767_n("twinDead");
        this.hasRetreated = par1NBTTagCompound.func_74767_n("hasFled");
        this.isRetreating = par1NBTTagCompound.func_74767_n("isRunning");
        this.runTimer = par1NBTTagCompound.func_74762_e("runTimer");
        this.newSpawn = par1NBTTagCompound.func_74767_n("newSpawn");
        if (this.isRetreating) {
            this.retreat = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 12.0f, 1.0, (double)0.4f);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.attack);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.followTwin);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.retreat);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.newSpawn) {
            this.spawnTwin();
        }
        if (!this.goodToGo && !this.isTwinDead()) {
            this.findTwin();
            this.goodToGo = true;
        }
        if (this.runTimer > 0) {
            --this.runTimer;
            if (this.runTimer < 1) {
                this.cancelRetreat();
            }
            if (this.isTwinDead()) {
                this.runTimer = 0;
                this.cancelRetreat();
            }
        }
        if (this.func_70638_az() != null) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.followTwin);
        } else if (this.isTwin() && !this.isRetreating && !this.isTwinDead()) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.followTwin);
        }
        if (!this.isTwinDead() && this.myTwin != null && this.func_70638_az() != null && ((EntityLizalfos)((Object)this.myTwinWeak.get())).func_70638_az() == null) {
            ((EntityLizalfos)((Object)this.myTwinWeak.get())).func_70624_b(this.func_70638_az());
        }
        if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f && !this.hasRetreated && !this.isRetreating && !this.isTwinDead()) {
            this.runAway();
            if (!this.isTwinDead() && this.myTwin != null) {
                ((EntityLizalfos)((Object)this.myTwinWeak.get())).cancelRetreat();
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource src, float amount) {
        if (src == DamageSource.field_76379_h) {
            return false;
        }
        if (src.func_76352_a()) {
            this.func_184185_a(AudioHandler.entityLizalfosBlock, 1.0f, (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
            return false;
        }
        return super.func_70097_a(src, amount);
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.5;
        Potion jump = Potion.func_180142_b((String)"jump_boost");
        if (this.func_70644_a(jump)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(jump).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float var1 = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)var1) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)var1) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    private void findTwin() {
        EntityLizalfos bar;
        boolean skipFlag = false;
        Entity foo = this.field_70170_p.func_73045_a(this.twinEntityID);
        if (foo instanceof EntityLizalfos && (bar = (EntityLizalfos)foo).getTwinID() == this.twinID && !bar.equals((Object)this)) {
            this.setTwin(bar);
            bar.setTwin(this);
            skipFlag = true;
        }
        if (!this.field_70170_p.field_72995_K && !skipFlag) {
            List allEntities;
            try {
                allEntities = this.field_70170_p.func_72910_y();
            }
            catch (NoSuchMethodError e) {
                allEntities = this.field_70170_p.func_72872_a(EntityLizalfos.class, this.func_174813_aQ().func_72321_a(48.0, 48.0, 48.0));
            }
            Iterator iter = allEntities.iterator();
            boolean foundFlag = false;
            while (iter.hasNext() && !foundFlag) {
                EntityLizalfos bar2;
                foo = (Entity)iter.next();
                if (!(foo instanceof EntityLizalfos) || foo.equals((Object)this) || this.twinID != (bar2 = (EntityLizalfos)foo).getTwinID()) continue;
                this.setTwin(bar2);
                bar2.setTwin(this);
                this.twinEntityID = this.getTwin().func_145782_y();
                this.getTwin().twinEntityID = this.func_145782_y();
                foundFlag = true;
            }
            if (this.isTwin()) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.followTwin);
            }
            Object var3_3 = null;
        }
    }

    public void cancelRetreat() {
        if (this.isRetreating) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.retreat);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.panic);
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.attack);
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.revenge);
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.target);
            this.isRetreating = false;
            this.hasRetreated = true;
            this.runTimer = 0;
        }
    }

    public void runAway() {
        this.isRetreating = true;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.followTwin);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.attack);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.revenge);
        this.field_70715_bh.func_85156_a((EntityAIBase)this.target);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.panic);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.retreat);
        this.runTimer = 480;
        this.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"regeneration"), 240, 1));
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var2;
        if (DungeonMobsHelper.getDifficulty(this.field_70170_p) > 0 && (var2 = this.field_70146_Z.nextInt(DungeonMobsHelper.getDifficulty(this.field_70170_p) + 1)) == 0) {
            Item aSword = Items.field_151040_l;
            ItemStack mySword = new ItemStack(aSword);
            EnchantmentHelper.func_77504_a((Random)this.field_70170_p.field_73012_v, (ItemStack)mySword, (int)15, (boolean)true);
            EntityItem itemEnt = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, mySword);
            this.field_70170_p.func_72838_d((Entity)itemEnt);
        }
    }

    public void func_180430_e(float dist, float multiplier) {
        BlockPos where;
        Block block;
        if ((dist = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)dist, (float)multiplier)[0]) <= 0.0f) {
            return;
        }
        int var2 = MathHelper.func_76123_f((float)(dist - 3.0f));
        if (var2 > 0 && (block = this.field_70170_p.func_180495_p(where = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()) != Blocks.field_150350_a) {
            SoundType sound = block.func_185467_w();
            this.func_184185_a(sound.func_185842_g(), sound.func_185843_a() * 0.5f, sound.func_185847_b() * 0.75f);
        }
    }

    private void spawnTwin() {
        this.newSpawn = false;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean successful = false;
        Collections.shuffle(locations);
        EntityLizalfos twin = new EntityLizalfos(this.field_70170_p, this, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (LocOffset offset : locations) {
            twin.func_70012_b(this.field_70165_t + offset.x, this.field_70163_u, this.field_70161_v + offset.z, this.field_70177_z, this.field_70125_A);
            if (!twin.func_70058_J()) continue;
            this.field_70170_p.func_72838_d((Entity)twin);
            this.twinEntityID = twin.func_145782_y();
            twin.twinEntityID = this.func_145782_y();
            successful = true;
            break;
        }
        if (!successful) {
            twin.func_70106_y();
            this.func_70106_y();
        }
    }

    private static class LocOffset {
        public double x;
        public double z;

        public LocOffset(int x, int z) {
            this.x = x;
            this.z = x;
        }
    }
}

