/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.EntityDungeonMob;
import com.gw.dm.entity.EntityIllithid;
import com.gw.dm.entity.EntityRakshasaImage;
import com.gw.dm.entity.IBeMagicMob;
import com.gw.dm.projectile.EntityMagicMissile;
import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityRakshasa
extends EntityDungeonMob
implements IRangedAttackMob,
IBeMagicMob {
    private static final ResourceLocation rakshasaTextures = new ResourceLocation("dungeonmobs", "textures/entity/Rakshasa.png");
    private static String mobName = "dungeonmobs:dmrakshasa";
    public boolean ignoreHeight = false;
    public String currentName;
    public ResourceLocation currentSkin;
    public boolean hasIllusion;
    private int castingTimer;
    private int hasteTimer;
    private int illusionTimer;
    private int imageTimer;
    private EntityAIAttackRanged rangeAttack = new EntityAIAttackRanged((IRangedAttackMob)this, (double)0.3f, 5, 40, 24.0f);
    private EntityAIAttackMelee meleeAttack = new EntityAIAttackMelee((EntityCreature)this, (double)0.3f, false);
    private List myImages;

    public EntityRakshasa(World par1World) {
        super(par1World);
        this.field_70728_aV = 60;
        this.castingTimer = 0;
        this.hasteTimer = 0;
        this.illusionTimer = 0;
        this.imageTimer = 0;
        this.currentName = "Rakshasa";
        this.currentSkin = rakshasaTextures;
        this.hasIllusion = false;
        this.myImages = new LinkedList();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.rangeAttack);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityRakshasa.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityIllithid.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(42.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * (double)ConfigHandler.damagex + (double)ConfigHandler.damageplus);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
    }

    public int func_70627_aG() {
        return 80;
    }

    protected SoundEvent func_184639_G() {
        return AudioHandler.entityRakshasaAmbient;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return AudioHandler.entityRakshasaHurt;
    }

    protected SoundEvent func_184615_bR() {
        return AudioHandler.entityRakshasaHurt;
    }

    public ResourceLocation getTexture() {
        return this.currentSkin;
    }

    public String getEntityName() {
        return this.currentName;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var2 = this.field_70146_Z.nextInt(DungeonMobsHelper.getDifficulty(this.field_70170_p));
        if (var2 == 0) {
            ItemStack myBook = new ItemStack(Items.field_151134_bR, 1);
            DungeonMobsHelper.addEnchantment(myBook, this.field_70146_Z);
            EntityItem itemEnt = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, myBook);
            this.field_70170_p.func_72838_d((Entity)itemEnt);
        }
    }

    public boolean func_70601_bi() {
        if (ConfigHandler.rakshasaIg || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (this.field_70170_p.func_175710_j(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (this.field_70163_u > 38.0 && !this.ignoreHeight) {
            return false;
        }
        return super.func_70601_bi();
    }

    public void func_82196_d(EntityLivingBase var1, float lol) {
        double var11 = var1.field_70165_t + var1.field_70159_w - this.field_70165_t;
        double var13 = var1.func_174813_aQ().field_72338_b + var1.field_70181_x + (double)var1.field_70131_O - this.func_174813_aQ().field_72337_e;
        double var15 = var1.field_70161_v + var1.field_70179_y - this.field_70161_v;
        EntityMagicMissile mm = new EntityMagicMissile(this.field_70170_p, (EntityLivingBase)this, ConfigHandler.rakshasaPtLvl);
        this.targetArrow(mm);
        this.field_70170_p.func_72838_d((Entity)mm);
    }

    protected void targetArrow(EntityArrow entityarrow) {
        EntityLivingBase target = this.func_70638_az();
        if (target == null) {
            return;
        }
        double vx = target.field_70165_t - this.field_70165_t;
        double vy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) + ((double)this.field_70146_Z.nextFloat() - 0.5) - entityarrow.field_70163_u;
        double vz = target.field_70161_v - this.field_70161_v;
        double dist = MathHelper.func_76133_a((double)(vx * vx + vz * vz));
        entityarrow.func_70186_c(vx, vy + dist / 5.0, vz, 1.6f, 0.0f);
    }

    @Override
    public void func_70636_d() {
        ++this.castingTimer;
        if (this.imageTimer > 0) {
            --this.imageTimer;
            if (this.imageTimer % 40 == 0) {
                this.switchPosition();
            }
        }
        if (this.hasteTimer > 0) {
            if (this.hasteTimer % 4 == 0) {
                ++this.castingTimer;
            }
            --this.hasteTimer;
        }
        if (this.castingTimer >= 120 && !this.field_70170_p.field_72995_K) {
            this.func_184185_a(AudioHandler.entityRakshasael, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            boolean castFlag = false;
            int castAttempts = 0;
            do {
                int castSelect = this.field_70170_p.field_73012_v.nextInt(5);
                switch (castSelect) {
                    case 0: {
                        Potion spell = Potion.func_180142_b((String)"invisibility");
                        if (!this.func_70644_a(spell)) {
                            this.func_70690_d(new PotionEffect(spell, 240, 1));
                            castFlag = true;
                            break;
                        }
                        ++castAttempts;
                        break;
                    }
                    case 1: {
                        Potion spell = Potion.func_180142_b((String)"resistance");
                        if (!this.func_70644_a(spell)) {
                            this.func_70690_d(new PotionEffect(spell, 240, 3));
                            castFlag = true;
                            break;
                        }
                        ++castAttempts;
                        break;
                    }
                    case 2: {
                        Potion spell = Potion.func_180142_b((String)"speed");
                        if (!this.func_70644_a(spell) && this.hasteTimer < 30) {
                            this.func_70690_d(new PotionEffect(spell, 240, 2));
                            this.hasteTimer = 240;
                            castFlag = true;
                            break;
                        }
                        ++castAttempts;
                        break;
                    }
                    case 3: {
                        if (this.imageTimer < 30) {
                            this.createImages();
                            castFlag = true;
                            break;
                        }
                        ++castAttempts;
                        break;
                    }
                    case 4: {
                        if (this.func_70638_az() != null) {
                            if (this.func_70685_l((Entity)this.func_70638_az())) {
                                this.func_82196_d(this.func_70638_az(), 0.0f);
                                castFlag = true;
                                break;
                            }
                            ++castAttempts;
                            break;
                        }
                        ++castAttempts;
                        break;
                    }
                    default: {
                        ++castAttempts;
                    }
                }
            } while (!castFlag && castAttempts < 6);
            this.castingTimer -= 120;
        }
        super.func_70636_d();
    }

    private void createImages() {
        this.imageTimer = 240;
        int imageAttempts = 0;
        int imageCount = this.field_70170_p.field_73012_v.nextInt(3) + DungeonMobsHelper.getDifficulty(this.field_70170_p);
        for (int i = 0; i < imageCount && imageAttempts < 3 + imageCount; ++i) {
            double imageX = this.field_70165_t + (double)(this.field_70170_p.field_73012_v.nextFloat() * 4.0f);
            double imageY = this.field_70163_u;
            double imageZ = this.field_70161_v + (double)(this.field_70170_p.field_73012_v.nextFloat() * 4.0f);
            EntityRakshasaImage bar = new EntityRakshasaImage(this.field_70170_p, this.func_70638_az(), this);
            bar.func_70012_b(imageX, imageY, imageZ, this.field_70177_z, this.field_70125_A);
            if (bar.func_70601_bi() && !this.field_70170_p.field_72995_K) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)bar);
                    this.myImages.add(bar);
                    if (this.func_70638_az() == null) continue;
                    bar.func_70624_b(this.func_70638_az());
                    continue;
                }
                --imageCount;
                ++imageAttempts;
                continue;
            }
            --imageCount;
            ++imageAttempts;
        }
    }

    private void switchPosition() {
        if (!this.field_70170_p.field_72995_K && !this.myImages.isEmpty()) {
            EntityRakshasaImage foo = (EntityRakshasaImage)((Object)this.myImages.get(this.field_70170_p.field_73012_v.nextInt(this.myImages.size())));
            double prevX = this.field_70165_t;
            double prevY = this.field_70163_u;
            double prevZ = this.field_70161_v;
            this.field_70165_t = foo.field_70165_t;
            this.field_70163_u = foo.field_70163_u;
            this.field_70161_v = foo.field_70161_v;
            foo.field_70165_t = prevX;
            foo.field_70163_u = prevY;
            foo.field_70161_v = prevZ;
        }
    }

    public void destroyImage(EntityRakshasaImage foo) {
        Iterator iter = this.myImages.iterator();
        while (iter.hasNext()) {
            if (!foo.equals((Object)((EntityRakshasaImage)((Object)iter.next())))) continue;
            this.myImages.remove((Object)foo);
            break;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("CastTimer", this.castingTimer);
        par1NBTTagCompound.func_74768_a("HasteTimer", this.hasteTimer);
        par1NBTTagCompound.func_74768_a("ImageTimer", this.imageTimer);
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.castingTimer = par1NBTTagCompound.func_74762_e("CastTimer");
        this.hasteTimer = par1NBTTagCompound.func_74762_e("HasteTimer");
        this.imageTimer = par1NBTTagCompound.func_74762_e("ImageTimer");
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

