/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.EntityDungeonMob;
import com.gw.dm.ai.EntityAIAttackAnythingWanted;
import com.gw.dm.ai.EntityAIFindItem;
import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import com.gw.dm.util.RMFoodItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityRustMonster
extends EntityDungeonMob {
    private static String mobName = "dungeonmobs:dmrustmonster";
    private static Set<RMFoodItem> foods = new HashSet<RMFoodItem>(Arrays.asList(new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150352_o)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150366_p)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150448_aq)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150318_D)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150331_J)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150340_R)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150339_S)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150411_aY)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150479_bC)), new RMFoodItem(Item.func_150898_a((Block)Blocks.field_150408_cc)), new RMFoodItem(Items.field_151036_c), new RMFoodItem(Items.field_151139_aw), new RMFoodItem(Items.field_151019_K), new RMFoodItem(Items.field_151138_bX), new RMFoodItem(Items.field_151042_j), new RMFoodItem(Items.field_191525_da), new RMFoodItem(Items.field_151035_b), new RMFoodItem(Items.field_151037_a), new RMFoodItem(Items.field_151040_l), new RMFoodItem((Item)Items.field_151167_ab), new RMFoodItem((Item)Items.field_151030_Z), new RMFoodItem((Item)Items.field_151028_Y), new RMFoodItem((Item)Items.field_151165_aa), new RMFoodItem(Items.field_151006_E), new RMFoodItem(Items.field_151150_bK), new RMFoodItem(Items.field_151153_ao), new RMFoodItem(Items.field_151013_M), new RMFoodItem(Items.field_151136_bY), new RMFoodItem(Items.field_151043_k), new RMFoodItem(Items.field_151074_bl), new RMFoodItem(Items.field_151005_D), new RMFoodItem(Items.field_151011_C), new RMFoodItem(Items.field_151010_B), new RMFoodItem((Item)Items.field_151151_aj), new RMFoodItem((Item)Items.field_151171_ah), new RMFoodItem((Item)Items.field_151169_ag), new RMFoodItem((Item)Items.field_151149_ai)));
    private Entity myTarget;
    private boolean pissed;
    private boolean ignoreHeight;

    public EntityRustMonster(World par1World) {
        super(par1World);
        this.func_70105_a(1.4f, 1.4f);
        this.field_70728_aV = 20;
        this.ignoreHeight = false;
        this.pissed = false;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackAnythingWanted((EntityCreature)this, Entity.class, 1.0f, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIFindItem(this, 24, foods));
    }

    public static void setFoods(List<String> list) {
        foods = new HashSet<RMFoodItem>();
        EntityRustMonster.appendToFoods(list);
    }

    public static void appendToFoods(List<String> list) {
        for (String rl : list) {
            StringTokenizer tokens = new StringTokenizer(rl, ":");
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(tokens.nextToken(), tokens.nextToken()));
            if (tokens.hasMoreTokens()) {
                foods.add(new RMFoodItem(item, Integer.parseInt(tokens.nextToken())));
                continue;
            }
            foods.add(new RMFoodItem(item));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0 * (double)ConfigHandler.damagex + (double)ConfigHandler.damageplus);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
    }

    public int func_70658_aO() {
        return 9;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected SoundEvent func_184639_G() {
        return AudioHandler.entityRustMonsterAmbient;
    }

    protected SoundEvent func_184601_bQ(DamageSource src) {
        return AudioHandler.entityRustMonsterHurt;
    }

    protected SoundEvent func_184615_bR() {
        return AudioHandler.entityRustMonsterDeath;
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_145779_a(Items.field_151044_h, this.field_70146_Z.nextInt(2) + par2);
        }
    }

    public boolean func_70601_bi() {
        if (ConfigHandler.rustMonsterIg || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (this.field_70170_p.func_175710_j(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (!this.ignoreHeight) {
            for (int i = -24; i < 24; ++i) {
                for (int j = -24; j < 24; ++j) {
                    for (int k = -24; k < 24; ++k) {
                        BlockPos where;
                        int checkX = (int)this.field_70165_t + i;
                        int checkY = (int)this.field_70163_u + j;
                        int checkZ = (int)this.field_70161_v + k;
                        if (checkY < 1) {
                            checkY = 1;
                        }
                        if (this.field_70170_p.func_180495_p(where = new BlockPos(checkX, checkY, checkZ)).func_177230_c() == Blocks.field_150366_p) {
                            return super.func_70601_bi();
                        }
                        if (this.field_70170_p.func_180495_p(where).func_177230_c() != Blocks.field_150352_o) continue;
                        return super.func_70601_bi();
                    }
                }
            }
            return false;
        }
        return super.func_70601_bi();
    }

    public int func_70627_aG() {
        return 120;
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.4;
        if (this.func_70644_a(Potion.func_180142_b((String)"jump_boost"))) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.func_180142_b((String)"jump_boost")).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float var1 = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)var1) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)var1) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public boolean func_70097_a(DamageSource src, float amount) {
        EntityPlayer player;
        ItemStack stack;
        if (src.func_76346_g() instanceof EntityPlayer && (stack = (player = (EntityPlayer)src.func_76346_g()).func_184614_ca()) != null && stack.func_77973_b() != null && foods.contains(new RMFoodItem(stack.func_77973_b(), stack.func_77952_i()))) {
            if (player.func_184614_ca().func_77984_f()) {
                int yar = this.field_70146_Z.nextInt(11) + 15;
                player.func_184614_ca().func_77972_a(yar, (EntityLivingBase)this);
            } else {
                int numToDestroy = this.func_70681_au().nextInt(6) + 1;
                for (int m = 0; m < numToDestroy; ++m) {
                    if (stack.func_190916_E() == 1) {
                        m = numToDestroy;
                    }
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
            }
        }
        return super.func_70097_a(src, amount);
    }

    public boolean func_70652_k(Entity ent) {
        if (ent instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ent;
            Iterable armors = player.func_184193_aE();
            for (ItemStack armorPiece : armors) {
                if (armorPiece == null || armorPiece.func_77973_b() == null || !foods.contains(new RMFoodItem(armorPiece.func_77973_b()))) continue;
                int lawlz = this.func_70681_au().nextInt(11) + 15;
                armorPiece.func_77972_a(lawlz, (EntityLivingBase)this);
            }
        }
        return super.func_70652_k(ent);
    }

    public Entity getTarget() {
        if (this.pissed) {
            return this.func_70638_az();
        }
        if (this.func_70638_az() == null) {
            return this.myTarget;
        }
        return this.func_70638_az();
    }

    public void setTarget(Entity targetEntity, boolean livingFlag) {
        this.myTarget = targetEntity;
    }
}

