/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.EntityDungeonMob;
import com.gw.dm.entity.EntityGhoul;
import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityShrieker
extends EntityMob {
    private static ResourceLocation[] entityNames = new ResourceLocation[]{new ResourceLocation("minecraft", "zombie"), new ResourceLocation("minecraft", "skeleton"), new ResourceLocation("minecraft", "spider"), new ResourceLocation("minecraft", "cave_spider"), new ResourceLocation("minecraft", "creeper"), new ResourceLocation("minecraft", "witch"), new ResourceLocation("minecraft", "enderman")};
    private static String mobName = "dungeonmobs:shrieker";
    private int screamTicks;
    private boolean hasScreamed;
    private int maxSummoned;
    private int cooldown;

    public EntityShrieker(World par1World) {
        super(par1World);
        this.field_70728_aV = 15;
        this.func_70105_a(1.0f, 1.0f);
        this.screamTicks = 0;
        this.maxSummoned = 5;
        this.cooldown = 0;
    }

    public static void appendToSummonList(String location) {
        StringTokenizer tokens = new StringTokenizer(location, ":");
        String modid = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            String msg = "Could not add mob " + location + "; name malformed.";
            System.err.println(msg);
            Logger.getLogger("Error").log(Level.WARNING, msg);
            return;
        }
        String name = tokens.nextToken();
        ResourceLocation[] newlist = new ResourceLocation[entityNames.length + 1];
        for (int ctr = 0; ctr < entityNames.length; ++ctr) {
            newlist[ctr] = entityNames[ctr];
        }
        newlist[ctr] = new ResourceLocation(modid, name);
        entityNames = null;
        entityNames = newlist;
    }

    private static void appendToSummonListNoGrow(String location, int index) {
        StringTokenizer tokens = new StringTokenizer(location, ":");
        String modid = tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            String msg = "Could not add mob " + location + "; name malformed.";
            System.err.println(msg);
            Logger.getLogger("Error").log(Level.WARNING, msg);
            return;
        }
        String name = tokens.nextToken();
        EntityShrieker.entityNames[index] = new ResourceLocation(modid, name);
    }

    public static void appendToSummonList(List<String> locations) {
        int ctr;
        ResourceLocation[] newlist = new ResourceLocation[entityNames.length + locations.size()];
        for (ctr = 0; ctr < entityNames.length; ++ctr) {
            newlist[ctr] = entityNames[ctr];
        }
        entityNames = newlist;
        for (String location : locations) {
            EntityShrieker.appendToSummonListNoGrow(location, ctr++);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public int func_70658_aO() {
        return 0;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v))) {
            this.func_70106_y();
        } else {
            float light = this.func_70013_c();
            this.hasScreamed = false;
            if (light > 0.08f) {
                ++this.screamTicks;
                if (this.screamTicks % 70 == 0) {
                    this.func_184185_a(AudioHandler.entityShrieker, 1.0f, 1.0f);
                    this.hasScreamed = true;
                }
                if (this.screamTicks % 150 == 0) {
                    if (this.field_70170_p.func_72890_a((Entity)this, 32.0) != null) {
                        this.summonMobs();
                    }
                    this.screamTicks = 0;
                }
            }
        }
        super.func_70636_d();
    }

    public boolean func_70097_a(DamageSource src, float amount) {
        if (src.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)src.func_76346_g();
            if (!player.field_71075_bZ.field_75098_d) {
                this.func_184185_a(AudioHandler.entityShrieker, 1.0f, 1.0f);
                int var = 0;
                switch (this.field_70170_p.func_175659_aa()) {
                    case EASY: {
                        var = 1;
                        break;
                    }
                    case HARD: {
                        var = 3;
                        break;
                    }
                    case NORMAL: {
                        var = 2;
                        break;
                    }
                }
                if (this.field_70146_Z.nextInt(4 - var) == 0) {
                    this.summonMobs();
                }
            }
        }
        return super.func_70097_a(src, amount);
    }

    protected void func_82167_n(Entity par1Entity) {
    }

    public void func_70100_b_(EntityPlayer ent) {
        if (!ent.field_71075_bZ.field_75098_d) {
            this.func_184185_a(AudioHandler.entityShrieker, 1.0f, 1.0f);
            this.summonMobs();
        }
    }

    public void func_70625_a(Entity par1Entity, float par2, float par3) {
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var3 = this.field_70146_Z.nextInt(2 + par2);
        for (int var4 = 0; var4 < var3; ++var4) {
            this.func_145779_a(Items.field_151075_bm, 1);
        }
    }

    public boolean func_70601_bi() {
        if (ConfigHandler.shriekerIg || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        BlockPos here = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.field_70170_p.func_175710_j(here)) {
            return false;
        }
        if (this.field_70163_u > 50.0) {
            return false;
        }
        if (this.field_70170_p.func_175699_k(here) > 4) {
            return false;
        }
        return super.func_70601_bi();
    }

    protected void summonMobs() {
        int numMobs = this.field_70146_Z.nextInt(4) + 1;
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
            ++numMobs;
            this.cooldown -= 5;
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
            numMobs += 3;
            this.cooldown -= 5;
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < numMobs; ++i) {
                int fubar = this.field_70146_Z.nextInt(entityNames.length);
                EntityLiving attracted = (EntityLiving)EntityList.func_188429_b((ResourceLocation)entityNames[fubar], (World)this.field_70170_p);
                if (attracted == null) {
                    return;
                }
                double spawnx = this.field_70165_t + this.field_70146_Z.nextDouble() * 8.0 - this.field_70146_Z.nextDouble() * 8.0;
                double spawny = this.field_70163_u - 1.0 + this.field_70146_Z.nextDouble() * 3.0;
                double spawnz = this.field_70161_v + this.field_70146_Z.nextDouble() * 8.0 - this.field_70146_Z.nextDouble() * 8.0;
                if (Math.abs(Math.abs(spawnx) - Math.abs(this.field_70165_t)) < 2.0) {
                    spawnx = spawnx < 0.0 ? (spawnx -= 2.0) : (spawnx += 2.0);
                }
                if (Math.abs(Math.abs(spawnz) - Math.abs(this.field_70161_v)) < 2.0) {
                    spawnz = spawnz < 0.0 ? (spawnz -= 2.0) : (spawnz += 2.0);
                }
                this.makeSummonIgnoreHeight(attracted);
                attracted.func_70012_b(spawnx, spawny + 1.0, spawnz, MathHelper.func_76142_g((float)(this.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                attracted.field_70759_as = attracted.field_70177_z;
                attracted.field_70761_aq = attracted.field_70177_z;
                if (!attracted.func_70601_bi() || this.field_70170_p.field_72995_K || !attracted.func_70058_J()) continue;
                this.field_70170_p.func_72838_d((Entity)attracted);
            }
        }
    }

    public boolean func_70686_a(Class par1Class) {
        return false;
    }

    private void makeSummonIgnoreHeight(EntityLiving ent) {
        if (ent instanceof EntityDungeonMob) {
            EntityDungeonMob foo = (EntityDungeonMob)ent;
            foo.setIgnoreHeight(true);
        } else if (ent instanceof EntityGhoul) {
            EntityGhoul foo = (EntityGhoul)ent;
            foo.setIgnoreHeight(true);
        }
    }
}

