/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.util.AudioHandler;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityTroll
extends EntityMob {
    private static String mobName = "dungeonmobs:dmtroll";
    public int stoneStatus = 1;
    public int stoneCounter = 0;
    public int regenTimer = 0;
    public static final float regen = (float)Math.max(0.3 + Math.log10(ConfigHandler.healthx), 0.1);

    public EntityTroll(World par1World) {
        super(par1World);
        this.field_70728_aV = 40;
        this.func_70105_a(1.3f, 2.5f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityAnimal.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAnimal.class, 0, true, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0 * (double)ConfigHandler.damagex + (double)ConfigHandler.damageplus);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public int func_70658_aO() {
        return 6;
    }

    public int getAttackStrength(Entity par1Entity) {
        return 5;
    }

    protected SoundEvent func_184639_G() {
        return AudioHandler.entityTrollAmbient;
    }

    protected SoundEvent func_184601_bQ(DamageSource ds) {
        return AudioHandler.entityTrollHurt;
    }

    protected SoundEvent func_184615_bR() {
        return AudioHandler.entityTrollDeath;
    }

    protected void playStepSound(int par1, int par2, int par3, int par4) {
        this.func_184185_a(AudioHandler.dmbts, 1.0f, 1.0f);
    }

    public int func_70627_aG() {
        return 80;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_175710_j(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (ConfigHandler.trollIg || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (!this.func_70814_o()) {
            return false;
        }
        return super.func_70601_bi();
    }

    protected boolean func_70814_o() {
        int var3;
        int var2;
        int var1 = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, new BlockPos(var1, var2 = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), var3 = MathHelper.func_76128_c((double)this.field_70161_v))) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int var4 = this.field_70170_p.func_175699_k(new BlockPos(var1, var2, var3));
        if (this.field_70170_p.func_72911_I()) {
            int var5 = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            var4 = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(var5);
        }
        return var4 <= this.field_70146_Z.nextInt(5);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_72935_r() && this.func_70013_c() > 0.5f && this.field_70170_p.func_175678_i(this.func_180425_c())) {
                if (this.func_70681_au().nextInt((int)this.func_110143_aJ() + 2) < ++this.stoneCounter) {
                    this.func_184185_a(AudioHandler.dmbts, 1.0f, 1.0f);
                    this.turnToStone();
                }
            } else if (!this.field_70128_L && this.func_110143_aJ() > 0.0f && !this.func_70027_ad()) {
                this.func_70606_j(this.func_110143_aJ() + regen);
            }
        }
        super.func_70636_d();
    }

    private void turnToStone() {
        if (!this.field_70170_p.field_72995_K) {
            this.regenTimer = -1;
            this.func_70106_y();
            int sx = (int)(this.func_174813_aQ().field_72340_a + (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a) / 2.0 - 0.5);
            int sz = (int)(this.func_174813_aQ().field_72339_c + (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c) / 2.0 - 0.5);
            this.field_70170_p.func_180501_a(new BlockPos(sx, (int)this.func_174813_aQ().field_72338_b, sz), Blocks.field_150348_b.func_176223_P(), 3);
            this.field_70170_p.func_180501_a(new BlockPos(sx, (int)this.func_174813_aQ().field_72338_b + 1, sz), Blocks.field_150348_b.func_176223_P(), 3);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var3 = this.field_70146_Z.nextInt(3);
        for (int var4 = 0; var4 < var3; ++var4) {
            this.func_145779_a(Items.field_151116_aA, 1);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("StoneStatus", this.stoneStatus);
        par1NBTTagCompound.func_74768_a("StoneCounter", this.stoneCounter);
        par1NBTTagCompound.func_74768_a("RegenTimer", this.regenTimer);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.stoneStatus = par1NBTTagCompound.func_74762_e("StoneStatus");
        this.stoneCounter = par1NBTTagCompound.func_74762_e("StoneCounter");
        this.regenTimer = par1NBTTagCompound.func_74762_e("RegenTimer");
    }

    public void func_70106_y() {
        this.regenTimer = -1;
        super.func_70106_y();
    }
}

