/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.entity;

import com.gw.dm.DungeonMobsDamageSource;
import com.gw.dm.EntityDungeonMob;
import com.gw.dm.ai.AIVampireAttack;
import com.gw.dm.entity.IBeMagicMob;
import com.gw.dm.util.ConfigHandler;
import com.gw.dm.util.DungeonMobsHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityVampire
extends EntityDungeonMob
implements IBeMagicMob {
    private static String mobName = "dungeonmobs:dmvampire";
    private boolean escaping;
    private boolean feelTrapped;

    public EntityVampire(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = ConfigHandler.hardcoreVampire ? 30 : 20;
        this.feelTrapped = false;
    }

    public boolean func_70662_br() {
        return true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIVampireAttack(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0 * (double)ConfigHandler.healthx);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.54);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * (double)ConfigHandler.damagex + (double)ConfigHandler.damageplus);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_72935_r() && this.func_70013_c() > 0.5f && this.field_70170_p.func_175678_i(this.func_180425_c())) {
                this.func_70015_d(8);
                this.func_70606_j(this.func_110143_aJ() - 1.0f);
            } else if (!this.field_70128_L && this.func_110143_aJ() > 0.0f) {
                this.func_70606_j(this.func_110143_aJ() + 0.05f);
            }
        }
        super.func_70636_d();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70652_k(Entity victim) {
        if (this.escaping) {
            this.setTrapped();
        }
        if (super.func_70652_k(victim)) {
            switch (this.field_70170_p.func_175659_aa()) {
                case EASY: {
                    this.energyDrain(victim, -1, 8.0f);
                    break;
                }
                case HARD: {
                    this.energyDrain(victim, -2, 12.0f);
                    break;
                }
                case NORMAL: {
                    this.energyDrain(victim, -1, 10.0f);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void energyDrain(Entity victim, int levels, float exhaustion) {
        if (victim instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)victim;
            player.func_71020_j(exhaustion);
            if (ConfigHandler.hardcoreVampire) {
                if (player.field_71068_ca < 0 - levels) {
                    player.func_70097_a(DungeonMobsDamageSource.ENERGY_DRAIN, 1024.0f);
                }
                player.func_82242_a(levels);
            }
            this.func_70691_i(2.0f);
        } else if (victim instanceof EntityLiving) {
            EntityLiving mob = (EntityLiving)victim;
            mob.func_70097_a(DungeonMobsDamageSource.ENERGY_DRAIN, exhaustion / 2.0f - (float)levels);
            this.func_70691_i(2.0f);
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        this.func_145779_a(Items.field_151043_k, this.field_70146_Z.nextInt(2) + par2);
        if (par1) {
            this.func_145779_a(Items.field_151166_bC, this.field_70146_Z.nextInt(2) + par2);
        }
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            return false;
        }
        if (ConfigHandler.vampireIg || DungeonMobsHelper.isNearSpawner(this.field_70170_p, (EntityLiving)this, mobName)) {
            return super.func_70601_bi();
        }
        if (this.field_70163_u > 32.0 && !this.ignoreHeight) {
            return false;
        }
        return super.func_70601_bi();
    }

    public void setRunning(boolean escape) {
        this.escaping = escape;
    }

    public void setTrapped() {
        this.feelTrapped = true;
    }

    public boolean isEscaping() {
        return this.escaping;
    }

    public boolean isTrapped() {
        return this.feelTrapped;
    }
}

