/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityCloudGenerator
extends EntityThrowable {
    private static final double RANGE = 25600.0;
    private PotionEffect type;
    private int color;
    private int duration;
    private int age;
    private double sx;
    private double sy;
    private double sz;

    public EntityCloudGenerator(World worldIn, EntityLivingBase thrower, PotionEffect effect) {
        super(worldIn, thrower);
        this.type = effect;
        this.color = effect.func_188419_a().func_76401_j();
        this.duration = 180;
        this.age = 0;
        this.sx = this.field_70165_t;
        this.sy = this.field_70163_u;
        this.sz = this.field_70161_v;
    }

    protected void func_70184_a(RayTraceResult result) {
        this.spawnAreaEffectCloud();
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        Potion effect = this.type.func_188419_a();
        compound.func_74768_a("EffectType", Potion.func_188409_a((Potion)effect));
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("FireAge", this.age);
        compound.func_74780_a("startX", this.sx);
        compound.func_74780_a("startY", this.sy);
        compound.func_74780_a("startZ", this.sz);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.type = (PotionEffect)PotionType.func_185168_a((String)"poison").func_185170_a().get(0);
        this.duration = compound.func_74762_e("Duration");
        this.age = compound.func_74762_e("FireAge");
        this.sx = compound.func_74769_h("startX");
        this.sy = compound.func_74769_h("startY");
        this.sz = compound.func_74769_h("startZ");
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.spawnGas();
        }
        if (this.traveled() > 25600.0 || ++this.age > this.duration) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    private void spawnAreaEffectCloud() {
        EntityAreaEffectCloud droppedCloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float powerLeft = (float)(1.0 - this.traveled() / 25600.0);
        droppedCloud.func_184481_a(this.func_85052_h());
        droppedCloud.func_184486_b(this.duration - this.age);
        droppedCloud.func_184483_a(2.5f + 2.0f * powerLeft);
        droppedCloud.func_184495_b(-0.5f);
        droppedCloud.func_184485_d(10);
        droppedCloud.func_184487_c(-droppedCloud.func_184490_j() / (float)droppedCloud.func_184489_o());
        droppedCloud.func_184496_a(new PotionEffect(this.type.func_188419_a(), this.type.func_76459_b(), this.type.func_76458_c()));
        this.field_70170_p.func_72838_d((Entity)droppedCloud);
    }

    private void spawnGas() {
        EntityAreaEffectCloud tempCloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        tempCloud.func_184481_a(this.func_85052_h());
        tempCloud.func_184486_b(10);
        tempCloud.func_184483_a(2.5f);
        tempCloud.func_184495_b(-0.5f);
        tempCloud.func_184485_d(10);
        tempCloud.func_184487_c(-tempCloud.func_184490_j() / (float)tempCloud.func_184489_o());
        tempCloud.func_184496_a(new PotionEffect(this.type.func_188419_a(), this.type.func_76459_b(), this.type.func_76458_c()));
        this.field_70170_p.func_72838_d((Entity)tempCloud);
    }

    public float func_70185_h() {
        return 0.0f;
    }

    private double traveled() {
        return (this.field_70165_t - this.sx) * (this.field_70165_t - this.sx) + (this.field_70163_u - this.sy) * (this.field_70163_u - this.sx) + (this.field_70161_v - this.sz) * (this.field_70161_v - this.sz);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }
}

