/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.projectile;

import com.gw.dm.DungeonMobsDamageSource;
import com.gw.dm.util.ConfigHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLightball
extends EntityThrowable {
    public static final DamageSource LIGHT_BALL = DungeonMobsDamageSource.LIGHT_BALL;
    private int age = 0;

    public EntityLightball(World worldIn) {
        super(worldIn);
    }

    public EntityLightball(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityLightball(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)result.field_72308_g;
                float dmg = ConfigHandler.damagex + ConfigHandler.damageplus / 5.0f;
                if (entity instanceof EntityPlayer) {
                    switch (this.field_70170_p.func_175659_aa()) {
                        case EASY: {
                            dmg = (float)((double)dmg * 0.5);
                            break;
                        }
                        case NORMAL: {
                            dmg = (float)((double)dmg * 0.75);
                            break;
                        }
                        case PEACEFUL: {
                            dmg = 0.0f;
                            break;
                        }
                    }
                }
                if (this.damageable(entity)) {
                    entity.func_70606_j(entity.func_110143_aJ() - dmg);
                    if (entity.func_110143_aJ() <= 0.0f) {
                        entity.func_70645_a(DamageSource.func_76358_a((EntityLivingBase)this.func_85052_h()));
                    }
                }
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.func_85052_h()), dmg);
            }
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            this.func_70106_y();
        }
    }

    private boolean damageable(EntityLivingBase entity) {
        boolean out;
        boolean bl = out = entity.func_190530_aW() || entity.field_70170_p.field_72995_K || (double)entity.func_110143_aJ() <= 0.0;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            out = out || player.func_184812_l_();
        }
        return !out;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        ++this.age;
        if (this.age >= 72 && this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0f, false, false);
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Age", this.age);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.age = compound.func_74762_e("Age");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_70090_H() {
        return false;
    }
}

