/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.projectile;

import com.gw.dm.entity.EntityDestrachan;
import com.gw.dm.projectile.EntityEyeRay;
import com.gw.dm.util.DungeonMobsHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySonicBoom
extends Entity {
    public EntityLiving shootingEntity;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private boolean inGround = false;
    private int ticksAlive = 0;
    private int ticksInAir = 0;
    private int explodeCount = 0;
    private int lastExplosionTick;

    public EntitySonicBoom(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
    }

    public EntitySonicBoom(World par1World, EntityLiving par2EntityLiving, double ax, double ay, double az) {
        super(par1World);
        this.shootingEntity = par2EntityLiving;
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(par2EntityLiving.field_70165_t, par2EntityLiving.field_70163_u + 1.0, par2EntityLiving.field_70161_v, par2EntityLiving.field_70177_z, par2EntityLiving.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        double dist = MathHelper.func_76133_a((double)((ax += this.field_70146_Z.nextGaussian() * 0.4) * ax + (ay += this.field_70146_Z.nextGaussian() * 0.4) * ay + (az += this.field_70146_Z.nextGaussian() * 0.4) * az));
        this.accelerationX = ax / dist * 0.1;
        this.accelerationY = ay / dist * 0.1;
        this.accelerationZ = az / dist * 0.1;
    }

    protected void onImpact(boolean lastAttempt) {
        if (this.ticksAlive > this.lastExplosionTick + 10) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, true);
            this.lastExplosionTick = this.ticksAlive;
            ++this.explodeCount;
        }
        if (this.explodeCount > DungeonMobsHelper.getDifficulty(this.field_70170_p)) {
            this.func_70106_y();
        }
        if (lastAttempt) {
            this.func_70106_y();
        }
    }

    protected float getMotionFactor() {
        return 0.8f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        return false;
    }

    public void func_70071_h_() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 1.0, 1.0, new int[0]);
        ++this.ticksAlive;
        if (this.ticksAlive % 50 == 0) {
            this.onImpact(false);
        }
        if (!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)))) {
            this.func_70106_y();
        } else if (!this.field_70128_L) {
            super.func_70071_h_();
            if (this.inGround) {
                if (this.field_70170_p.func_175623_d(new BlockPos(this.xTile, this.yTile, this.zTile))) {
                    if (this.ticksAlive == 600) {
                        this.func_70106_y();
                    }
                    return;
                }
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksAlive = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3d var15 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d var2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult var3 = this.field_70170_p.func_72933_a(var15, var2);
            var15 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            var2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (var3 != null) {
                var2 = new Vec3d(var3.field_72307_f.field_72450_a, var3.field_72307_f.field_72448_b, var3.field_72307_f.field_72449_c);
            }
            Entity var4 = null;
            List var5 = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
            double var6 = 0.0;
            for (int var8 = 0; var8 < var5.size(); ++var8) {
                double var13;
                Entity var9 = (Entity)var5.get(var8);
                if (!var9.func_70067_L() || var9.func_70028_i((Entity)this.shootingEntity) || var9 instanceof EntityDestrachan || var9 instanceof EntityArrow || var9 instanceof EntityThrowable || var9 instanceof EntityEyeRay) continue;
                float var10 = 0.3f;
                AxisAlignedBB var11 = var9.func_174813_aQ().func_72321_a((double)var10, (double)var10, (double)var10);
                RayTraceResult var12 = var11.func_72327_a(var15, var2);
                if (var12 == null || !((var13 = var15.func_72438_d(var12.field_72307_f)) < var6) && var6 != 0.0) continue;
                var4 = var9;
                var6 = var13;
            }
            if (var4 != null) {
                var3 = new RayTraceResult(var4);
            }
            if (var3 != null) {
                this.onImpact(true);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float var16 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) + 90.0f;
            this.field_70125_A = (float)(Math.atan2(var16, this.field_70181_x) * 180.0 / Math.PI) - 90.0f;
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float var17 = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int var19 = 0; var19 < 4; ++var19) {
                    float var18 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)var18, this.field_70163_u - this.field_70181_x * (double)var18, this.field_70161_v - this.field_70179_y * (double)var18, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                var17 = 0.8f;
            }
            this.field_70159_w += this.accelerationX;
            this.field_70181_x += this.accelerationY;
            this.field_70179_y += this.accelerationZ;
            this.field_70159_w *= (double)var17;
            this.field_70181_x *= (double)var17;
            this.field_70179_y *= (double)var17;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.xTile);
        par1NBTTagCompound.func_74777_a("yTile", (short)this.yTile);
        par1NBTTagCompound.func_74777_a("zTile", (short)this.zTile);
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        par1NBTTagCompound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        par1NBTTagCompound.func_74768_a("explosionCount", this.explodeCount);
        par1NBTTagCompound.func_74768_a("lastExplode", this.lastExplosionTick);
        par1NBTTagCompound.func_74768_a("ticksAlive", this.ticksAlive);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.func_74765_d("xTile");
        this.yTile = par1NBTTagCompound.func_74765_d("yTile");
        this.zTile = par1NBTTagCompound.func_74765_d("zTile");
        boolean bl = this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        if (par1NBTTagCompound.func_74764_b("direction")) {
            NBTTagList var2 = par1NBTTagCompound.func_150295_c("direction", 6);
            this.field_70159_w = var2.func_150309_d(0);
            this.field_70181_x = var2.func_150309_d(1);
            this.field_70179_y = var2.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
        this.explodeCount = par1NBTTagCompound.func_74762_e("explosionCount");
        this.lastExplosionTick = par1NBTTagCompound.func_74762_e("lastExplode");
        this.ticksAlive = par1NBTTagCompound.func_74762_e("ticksAlive");
    }

    public boolean func_70067_L() {
        return false;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public float getBrightness(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    protected void func_70088_a() {
    }

    public void func_70106_y() {
        super.func_70106_y();
    }
}

