/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.util;

import com.gw.dm.util.DungeonMobsHelper;
import com.gw.dm.util.MiscRegistrar;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class DMGenerationHandler
implements IWorldGenerator {
    private static final Set<Block> targets = new HashSet<Block>();

    public DMGenerationHandler() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)100);
    }

    public static void initTargetBlocks() {
        targets.add(Blocks.field_150417_aV);
        targets.add(Blocks.field_150390_bg);
        targets.add(Blocks.field_150347_e);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_72995_K) {
            return;
        }
        this.generateTraps(chunkGenerator, world, world.field_73012_v, chunkX, chunkZ);
    }

    private void generateTraps(IChunkGenerator iChunkGenerator, World world, Random rand, int chunkX, int chunkZ) {
        int posX = chunkX << 4;
        int posZ = chunkZ << 4;
        BlockPos foo = iChunkGenerator.func_180513_a(world, "Stronghold", new BlockPos(posX, 64, posZ), false);
        boolean sh = foo == null ? false : foo.func_177958_n() >> 4 == chunkX && foo.func_177952_p() >> 4 == chunkZ;
        int max = 0;
        EnumDifficulty diff = world.func_175659_aa();
        if (diff != EnumDifficulty.PEACEFUL) {
            max = rand.nextInt(8) + rand.nextInt(3) + 2;
            if (diff == EnumDifficulty.NORMAL) {
                max += rand.nextInt(3) + 3;
            }
            if (diff == EnumDifficulty.HARD) {
                max += rand.nextInt(3) + 3;
                max += rand.nextInt(3) + 3;
            }
        }
        int match = world.field_73012_v.nextInt(10 - DungeonMobsHelper.getDifficulty(world));
        block0: for (int i = 0; i < max; ++i) {
            int x = posX + world.field_73012_v.nextInt(16);
            int z = posZ + world.field_73012_v.nextInt(16);
            int lower = 10;
            int upper = 64;
            if (i % 3 == match || sh && i % 2 == 0) {
                do {
                    if (!targets.contains(world.func_180495_p(new BlockPos(x, lower, z)).func_177230_c()) || !world.func_175623_d(new BlockPos(x, lower + 1, z))) continue;
                    world.func_180501_a(new BlockPos(x, lower + 1, z), MiscRegistrar.blockBladeTrap.func_176223_P(), 3);
                    continue block0;
                } while (++lower < upper);
                continue;
            }
            if (sh) {
                do {
                    if (!targets.contains(world.func_180495_p(new BlockPos(x, upper, z)).func_177230_c()) || !world.func_175623_d(new BlockPos(x, upper + 1, z))) continue;
                    world.func_180501_a(new BlockPos(x, upper + 1, z), MiscRegistrar.blockBladeTrap.func_176223_P(), 3);
                    continue block0;
                } while (lower < --upper);
                continue;
            }
            lower = rand.nextInt(54) + 10;
            if (!targets.contains(world.func_180495_p(new BlockPos(x, lower, z)).func_177230_c()) || !world.func_175623_d(new BlockPos(x, lower + 1, z))) continue;
            world.func_180501_a(new BlockPos(x, lower + 1, z), MiscRegistrar.blockBladeTrap.func_176223_P(), 3);
        }
    }
}

