/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.util;

import com.gw.dm.network.ConfusionPacket;
import com.gw.dm.network.KnockBackPacket;
import com.gw.dm.network.NetworkHelper;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class DungeonMobsHelper {
    public static boolean displayedVersion = false;
    private static NetworkHelper helper = NetworkHelper.getNetworkHelper();
    private static LinkedList confusedClientPlayers = new LinkedList();
    private static LinkedList confusedPlayers = new LinkedList();

    public static void printLists() {
        int i;
        System.out.println("[DM] Printing " + confusedClientPlayers.size() + " client players.");
        for (i = 0; i < confusedClientPlayers.size(); ++i) {
            System.out.println("[DM] " + confusedClientPlayers.get(i).toString());
        }
        System.out.println("[DM] Printing " + confusedPlayers.size() + " players.");
        for (i = 0; i < confusedPlayers.size(); ++i) {
            System.out.println("[DM] " + confusedPlayers.get(i).toString());
        }
    }

    public static void sendConfusionPacket(EntityPlayerMP target, boolean b) {
        EntityPlayerMP test = target;
        if (!(test instanceof FakePlayer)) {
            helper.sendPacketToPlayer(new ConfusionPacket(b), target);
        }
    }

    public static void makePlayerConfused(EntityPlayerMP player) {
        if (!confusedPlayers.contains(player)) {
            confusedPlayers.add(player);
        }
    }

    public static boolean isPlayerConfused(EntityPlayerMP player) {
        return confusedPlayers.contains(player);
    }

    public static void makePlayerNormal(EntityPlayerMP player) {
        if (confusedPlayers.contains(player)) {
            confusedPlayers.remove(player);
        }
    }

    public static void sendKnockBackPacket(EntityPlayerMP target, double xVel, double zVel) {
        EntityPlayerMP test = target;
        if (!(test instanceof FakePlayer)) {
            helper.sendPacketToPlayer(new KnockBackPacket((float)xVel, (float)zVel), target);
        }
    }

    public static void knockBack(EntityLivingBase target, double x, double z) {
        target.field_70160_al = true;
        float normalizedPower = MathHelper.func_76133_a((double)(x * x + z * z));
        float knockPower = 0.8f;
        target.field_70159_w /= 2.0;
        target.field_70181_x /= 2.0;
        target.field_70179_y /= 2.0;
        target.field_70159_w -= x / (double)normalizedPower * (double)knockPower;
        target.field_70181_x += (double)knockPower;
        target.field_70179_y -= z / (double)normalizedPower * (double)knockPower;
        if (target.field_70181_x > (double)0.4f) {
            target.field_70181_x = 0.4f;
        }
    }

    public static int getDifficulty(World world) {
        if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return 0;
        }
        if (world.func_175659_aa() == EnumDifficulty.EASY) {
            return 1;
        }
        if (world.func_175659_aa() == EnumDifficulty.NORMAL) {
            return 2;
        }
        if (world.func_175659_aa() == EnumDifficulty.HARD) {
            return 3;
        }
        return 0;
    }

    public static boolean isNearSpawner(World world, EntityLiving entity, String name) {
        int minx = (int)(entity.field_70165_t - 4.0);
        int maxx = (int)(entity.field_70165_t + 5.0);
        int miny = (int)(entity.field_70163_u - 1.0);
        int maxy = (int)(entity.field_70163_u + 2.0);
        int minz = (int)(entity.field_70161_v - 4.0);
        int maxz = (int)(entity.field_70161_v + 5.0);
        boolean out = false;
        for (int i = minx; i < maxx; ++i) {
            for (int j = miny; j < maxy; ++j) {
                for (int k = minz; k < maxz; ++k) {
                    TileEntity te;
                    BlockPos test = new BlockPos(i, j, k);
                    if (world.func_180495_p(test).func_177230_c() != Blocks.field_150474_ac || !((te = world.func_175625_s(test)) instanceof TileEntityMobSpawner)) continue;
                    try {
                        String id;
                        String mobSpawnEntityId;
                        NBTTagCompound spawnData;
                        TileEntityMobSpawner mobSpawner = (TileEntityMobSpawner)te;
                        NBTTagCompound nbt = new NBTTagCompound();
                        mobSpawner.func_145881_a().func_189530_b(nbt);
                        if (!nbt.func_74764_b("SpawnData") || !(spawnData = nbt.func_74775_l("SpawnData")).func_74764_b("id") || !(mobSpawnEntityId = spawnData.func_74779_i("id")).equalsIgnoreCase(id = name)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return out;
    }

    public static void addEnchantment(ItemStack stack, Random rand) {
        int n = rand.nextInt(2) + rand.nextInt(2) + 1;
        for (int i = 0; i < n; ++i) {
            Enchantment ench = (Enchantment)Enchantment.field_185264_b.func_186801_a(rand);
            int l = ench.func_77325_b();
            stack.func_77966_a(ench, l);
        }
    }
}

