/*
 * Decompiled with CFR 0.152.
 */
package com.gw.dm.util;

import com.gw.dm.Items.ItemLavarock;
import com.gw.dm.blocks.BlockBladeTrap;
import com.gw.dm.blocks.BlockLavarock;
import com.gw.dm.blocks.IHaveModel;
import com.gw.dm.blocks.TileEntityBladeTrap;
import com.gw.dm.potion.PotionAddle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MiscRegistrar {
    private static final List<Block> BLOCKS = new ArrayList<Block>();
    private static final List<Item> ITEMS = new ArrayList<Item>();
    public static BlockLavarock blockLavarock;
    public static ItemLavarock itemLavarock;
    public static BlockBladeTrap blockBladeTrap;
    public static ItemBlock itemBladeTrap;
    public static PotionAddle potionAddle;

    public static void initBlocks() {
        blockLavarock = new BlockLavarock();
        blockBladeTrap = new BlockBladeTrap();
    }

    public static void initItems() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry regs = event.getRegistry();
        for (Block block : BLOCKS) {
            regs.register((IForgeRegistryEntry)block);
        }
        MiscRegistrar.registerTileEntities();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry regs = event.getRegistry();
        for (Item item : ITEMS) {
            regs.register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        potionAddle = new PotionAddle(true, 0);
        event.getRegistry().register((IForgeRegistryEntry)potionAddle);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : ITEMS) {
            if (!(item instanceof IHaveModel)) continue;
            ((IHaveModel)item).registerModel();
        }
        for (Block block : BLOCKS) {
            if (!(block instanceof IHaveModel)) continue;
            ((IHaveModel)block).registerModel();
        }
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBladeTrap.class, (String)"dungeonmobs.bladetrap");
    }

    public static void addBlock(Block in) {
        BLOCKS.add(in);
    }

    public static void addItem(Item in) {
        ITEMS.add(in);
    }
}

