/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.blocks;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public final class BlockGolemHead
extends BlockHorizontal {
    public BlockGolemHead() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_196625_cS));
        this.func_180632_j((IBlockState)((IBlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D});
    }

    public IBlockState getStateForPlacement(IBlockState state, EnumFacing facing, IBlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, EnumHand hand) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)facing.func_176734_d());
    }

    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        super.func_196259_b(state, worldIn, pos, state);
        BlockGolemHead.trySpawnGolem(worldIn, pos);
    }

    public static boolean trySpawnGolem(World world, BlockPos headPos) {
        if (world.field_72995_K) {
            return false;
        }
        IBlockState stateBelow1 = world.func_180495_p(headPos.func_177979_c(1));
        IBlockState stateBelow2 = world.func_180495_p(headPos.func_177979_c(2));
        IBlockState stateArmNorth = world.func_180495_p(headPos.func_177979_c(1).func_177964_d(1));
        IBlockState stateArmSouth = world.func_180495_p(headPos.func_177979_c(1).func_177970_e(1));
        IBlockState stateArmEast = world.func_180495_p(headPos.func_177979_c(1).func_177965_g(1));
        IBlockState stateArmWest = world.func_180495_p(headPos.func_177979_c(1).func_177985_f(1));
        Block blockBelow1 = stateBelow1.func_177230_c();
        Block blockBelow2 = stateBelow2.func_177230_c();
        Block blockArmNorth = stateArmNorth.func_177230_c();
        Block blockArmSouth = stateArmSouth.func_177230_c();
        Block blockArmEast = stateArmEast.func_177230_c();
        Block blockArmWest = stateArmWest.func_177230_c();
        double spawnX = (double)headPos.func_177958_n() + 0.5;
        double spawnY = (double)headPos.func_177956_o() - 1.95;
        double spawnZ = (double)headPos.func_177952_p() + 0.5;
        if (BlockGolemHead.doBlocksMatch(Blocks.field_196604_cC, blockBelow1, blockBelow2)) {
            BlockGolemHead.removeGolemBody(world, headPos);
            EntitySnowman entitysnowman = new EntitySnowman(world);
            ExtraGolems.LOGGER.info("[Extra Golems]: Building regular boring Snow Golem");
            entitysnowman.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.func_72838_d((Entity)entitysnowman);
            return true;
        }
        boolean isIron = BlockGolemHead.doBlocksMatch(Blocks.field_150339_S, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        boolean flagX = false;
        if (!isIron) {
            isIron = BlockGolemHead.doBlocksMatch(Blocks.field_150339_S, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            flagX = true;
        }
        if (isIron) {
            BlockGolemHead.removeAllGolemBlocks(world, headPos, flagX);
            EntityIronGolem ironGolem = new EntityIronGolem(world);
            ExtraGolems.LOGGER.info("[Extra Golems]: Building regular boring Iron Golem");
            ironGolem.func_70849_f(true);
            ironGolem.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            world.func_72838_d((Entity)ironGolem);
            return true;
        }
        GolemBase golem = GolemRegistrar.getGolem(world, blockBelow1, blockBelow2, blockArmNorth, blockArmSouth);
        flagX = false;
        if (golem == null) {
            golem = GolemRegistrar.getGolem(world, blockBelow1, blockBelow2, blockArmEast, blockArmWest);
            flagX = true;
        }
        if (golem != null && golem.getGolemContainer().isEnabled()) {
            BlockGolemHead.removeAllGolemBlocks(world, headPos, flagX);
            golem.setPlayerCreated(true);
            golem.func_70012_b(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
            ExtraGolems.LOGGER.info("[Extra Golems]: Building golem " + golem.toString());
            world.func_72838_d((Entity)golem);
            golem.onBuilt(stateBelow1, stateBelow2, flagX ? stateArmEast : stateArmWest, flagX ? stateArmNorth : stateArmSouth);
            if (!golem.updateHomeVillage()) {
                golem.func_175449_a(golem.func_180425_c(), 64);
            }
            return true;
        }
        return false;
    }

    public static boolean doBlocksMatch(Block master, Block ... toCheck) {
        boolean success = toCheck != null && toCheck.length > 0;
        for (Block b : toCheck) {
            success &= b == master;
        }
        return success;
    }

    public static void removeAllGolemBlocks(World world, BlockPos pos, boolean isXAligned) {
        BlockGolemHead.removeGolemBody(world, pos);
        BlockGolemHead.removeGolemArms(world, pos, isXAligned);
    }

    public static void removeGolemBody(World world, BlockPos head) {
        world.func_175655_b(head, false);
        world.func_175655_b(head.func_177979_c(1), false);
        world.func_175655_b(head.func_177979_c(2), false);
    }

    public static void removeGolemArms(World world, BlockPos pos, boolean isXAligned) {
        if (isXAligned) {
            world.func_175655_b(pos.func_177979_c(1).func_177985_f(1), false);
            world.func_175655_b(pos.func_177979_c(1).func_177965_g(1), false);
        } else {
            world.func_175655_b(pos.func_177979_c(1).func_177964_d(1), false);
            world.func_175655_b(pos.func_177979_c(1).func_177970_e(1), false);
        }
    }
}

