/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.blocks;

import com.mcmoddev.golems.blocks.BlockUtility;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockUtilityPower
extends BlockUtility {
    public static final IntegerProperty POWER_LEVEL = IntegerProperty.func_177719_a((String)"power", (int)0, (int)15);
    public static final int UPDATE_TICKS = 4;

    public BlockUtilityPower(int powerLevel, int tickRate) {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200944_c(), tickRate);
        this.func_180632_j((IBlockState)this.func_176223_P().func_206870_a((IProperty)POWER_LEVEL, (Comparable)Integer.valueOf(powerLevel)));
    }

    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        boolean hasPowerGolem;
        AxisAlignedBB toCheck = new AxisAlignedBB(pos).func_186662_g(0.5);
        List list = worldIn.func_72872_a(GolemBase.class, toCheck);
        boolean bl = hasPowerGolem = list != null && !list.isEmpty() && this.hasPowerGolem(list);
        if (hasPowerGolem) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReaderBase)worldIn));
        } else {
            this.remove(worldIn, state, pos, 3);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{POWER_LEVEL});
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER_LEVEL);
    }

    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER_LEVEL);
    }

    protected boolean hasPowerGolem(List<GolemBase> golems) {
        for (GolemBase g : golems) {
            if (!g.doesProvidePower()) continue;
            return true;
        }
        return false;
    }
}

