/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public final class EntityCraftingGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Crafting";

    public EntityCraftingGolem(World world) {
        super(EntityCraftingGolem.class, world);
        this.setLootTableLoc("golem_crafting");
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityCraftingGolem.makeTexture("golems", "golem_crafting");
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && itemstack.func_190926_b()) {
            player.func_180468_a((IInteractionObject)new InterfaceCraftingGrid(player.field_70170_p, player.field_71081_bT));
            player.func_195066_a(StatList.field_188062_ab);
            player.func_184609_a(hand);
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187897_gY;
    }

    public static class InterfaceCraftingGrid
    extends BlockWorkbench.InterfaceCraftingTable {
        private final World world2;
        private final BlockPos position2;

        public InterfaceCraftingGrid(World worldIn, BlockPos pos) {
            super(worldIn, pos);
            this.world2 = worldIn;
            this.position2 = pos;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerPortableWorkbench(playerInventory, this.world2, this.position2);
        }
    }

    public static class ContainerPortableWorkbench
    extends ContainerWorkbench {
        public ContainerPortableWorkbench(InventoryPlayer playerInventory, World worldIn, BlockPos posIn) {
            super(playerInventory, worldIn, posIn);
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    }
}

