/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.events.IceGolemFreezeEvent;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class EntityIceGolem
extends GolemBase {
    public static final String AOE = "Area of Effect";
    public static final String FROST = "Use Frosted Ice";

    public EntityIceGolem(World world) {
        super(EntityIceGolem.class, world);
        this.setCanSwim(true);
        this.setLootTableLoc("golem_ice");
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityIceGolem.makeTexture("golems", "golem_ice");
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 2 == 0) {
            IceGolemFreezeEvent event;
            int aoe;
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            BlockPos below = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), z = MathHelper.func_76128_c((double)this.field_70161_v));
            if (this.field_70170_p.func_180494_b(below).func_180626_a(below) > 1.0f) {
                this.func_70097_a(DamageSource.field_76370_b, 1.0f);
            }
            if ((aoe = this.getConfigInt(AOE)) > 0 && !MinecraftForge.EVENT_BUS.post((Event)(event = new IceGolemFreezeEvent(this, below, aoe))) && event.getResult() != Event.Result.DENY) {
                this.freezeBlocks(event.getAffectedPositions(), event.getFunction(), event.updateFlag);
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity.func_70027_ad()) {
                this.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
            return true;
        }
        return false;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187561_bM;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }

    public boolean freezeBlocks(List<BlockPos> positions, Function<IBlockState, IBlockState> function, int updateFlag) {
        boolean flag = true;
        for (BlockPos pos : positions) {
            flag &= this.field_70170_p.func_180501_a(pos, function.apply(this.field_70170_p.func_180495_p(pos)), updateFlag);
        }
        return flag;
    }
}

