/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public final class EntityLapisGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Potion Effects";
    private static final Potion[] badEffects = new Potion[]{MobEffects.field_76440_q, MobEffects.field_76421_d, MobEffects.field_76436_u, MobEffects.field_76433_i, MobEffects.field_76437_t, MobEffects.field_82731_v, MobEffects.field_188424_y, MobEffects.field_188423_x};

    public EntityLapisGolem(World world) {
        super(EntityLapisGolem.class, world);
        this.setLootTableLoc("golem_lapis");
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.4);
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntityLapisGolem.makeTexture("golems", "golem_lapis");
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn) && entityIn instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)entityIn;
            if (this.getConfigBool(ALLOW_SPECIAL)) {
                Potion potionID = entity.func_70662_br() ? MobEffects.field_76432_h : badEffects[this.field_70146_Z.nextInt(badEffects.length)];
                int len = potionID.func_76403_b() ? 1 : 20 * (5 + this.field_70146_Z.nextInt(9));
                int amp = potionID.func_76403_b() ? this.field_70146_Z.nextInt(2) : this.field_70146_Z.nextInt(3);
                entity.func_195064_c(new PotionEffect(potionID, len, amp));
            }
            return true;
        }
        return false;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

