/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class EntityMagmaGolem
extends GolemBase {
    public static final String ALLOW_FIRE_SPECIAL = "Allow Special: Burn Enemies";
    public static final String ALLOW_LAVA_SPECIAL = "Allow Special: Melt Cobblestone";
    public static final String ALLOW_SPLITTING = "Allow Special: Split";
    public static final String ALLOW_WATER_DAMAGE = "Enable Water Damage";
    public static final String MELT_DELAY = "Melting Delay";
    private static final String TEXTURE_LOC = "golems:textures/entity/magma/golem_magma";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("golems:textures/entity/magma/golem_magma_0.png"), new ResourceLocation("golems:textures/entity/magma/golem_magma_1.png"), new ResourceLocation("golems:textures/entity/magma/golem_magma_2.png"), new ResourceLocation("golems:textures/entity/magma/golem_magma_3.png"), new ResourceLocation("golems:textures/entity/magma/golem_magma_2.png"), new ResourceLocation("golems:textures/entity/magma/golem_magma_1.png")};
    private int ticksStandingStill = 0;
    private int stillX;
    private int stillZ;
    private boolean isHurtByWater = this.getConfigBool("Enable Water Damage");
    private boolean allowMelting = this.getConfigBool("Allow Special: Melt Cobblestone");
    private int meltDelay = this.getConfigInt("Melting Delay");

    public EntityMagmaGolem(World world, boolean isChild) {
        this(world);
        this.setChild(isChild);
    }

    public EntityMagmaGolem(World world) {
        super(EntityMagmaGolem.class, world);
        this.setImmuneToFire(true);
        this.setCanSwim(!this.isHurtByWater);
        this.setLootTableLoc("golem_magma");
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (BABY.equals(key)) {
            if (this.func_70631_g_()) {
                this.func_70105_a(0.7f, 1.45f);
                this.allowMelting = false;
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.container.getAttack() * (double)0.6f);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.container.getHealth() / 3.0);
            } else {
                this.func_70105_a(1.4f, 2.9f);
                this.allowMelting = this.getConfigBool(ALLOW_LAVA_SPECIAL);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.container.getAttack());
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.container.getHealth());
            }
        }
    }

    @Override
    protected ResourceLocation applyTexture() {
        return TEXTURES[0];
    }

    @Override
    public ResourceLocation getTextureType() {
        int changeInterval = 5;
        int textureNum = (this.field_70173_aa + this.func_145782_y()) / 5 % TEXTURES.length;
        return TEXTURES[textureNum];
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (!this.func_70631_g_() && this.getConfigBool(ALLOW_FIRE_SPECIAL)) {
                entity.func_70015_d(2 + this.field_70146_Z.nextInt(5));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.isHurtByWater && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 0.5f);
        }
        if (this.allowMelting && !this.func_70631_g_()) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            BlockPos below = new BlockPos(x, y, z);
            Block b1 = this.field_70170_p.func_180495_p(below).func_177230_c();
            if (x == this.stillX && z == this.stillZ) {
                if (++this.ticksStandingStill >= this.meltDelay && b1 == Blocks.field_150347_e && this.field_70146_Z.nextInt(16) == 0) {
                    IBlockState replace = Blocks.field_196814_hQ.func_176223_P();
                    this.field_70170_p.func_180501_a(below, replace, 3);
                    this.ticksStandingStill = 0;
                }
            } else {
                this.ticksStandingStill = 0;
                this.stillX = x;
                this.stillZ = z;
            }
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource ignored) {
        return ignored == DamageSource.field_76369_e ? SoundEvents.field_187659_cY : this.getGolemSound();
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.getConfigBool(ALLOW_SPLITTING)) {
            EntityMagmaGolem slime1 = new EntityMagmaGolem(this.field_70170_p, true);
            EntityMagmaGolem slime2 = new EntityMagmaGolem(this.field_70170_p, true);
            if (this.func_70638_az() != null) {
                slime1.func_70624_b(this.func_70638_az());
                slime2.func_70624_b(this.func_70638_az());
            }
            slime1.func_70012_b(this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, this.field_70177_z + (float)this.field_70146_Z.nextInt(20) - 10.0f, 0.0f);
            slime2.func_70012_b(this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, this.field_70177_z + (float)this.field_70146_Z.nextInt(20) - 10.0f, 0.0f);
            this.func_130014_f_().func_72838_d((Entity)slime1);
            this.func_130014_f_().func_72838_d((Entity)slime2);
        }
        super.func_70106_y();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187902_gb;
    }
}

