/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.ai.EntityAIPlaceRandomBlocksStrictly;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public final class EntityMushroomGolem
extends GolemMultiTextured {
    public static final String ALLOW_SPECIAL = "Allow Special: Plant Mushrooms";
    public static final String FREQUENCY = "Mushroom Frequency";
    public static final String ALLOW_HEALING = "Allow Special: Random Healing";
    public static final String SHROOM_PREFIX = "shroom";
    public static final String[] SHROOM_TYPES = new String[]{"red", "brown"};

    public EntityMushroomGolem(World world) {
        super(EntityMushroomGolem.class, world, SHROOM_PREFIX, SHROOM_TYPES);
        this.setCanSwim(true);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        boolean allowed = this.getConfigBool(ALLOW_SPECIAL);
        int freq = allowed ? this.getConfigInt(FREQUENCY) : -100;
        freq += this.field_70146_Z.nextInt(Math.max(10, freq / 2));
        IBlockState[] mushrooms = new IBlockState[]{Blocks.field_150338_P.func_176223_P(), Blocks.field_150337_Q.func_176223_P()};
        Block[] soils = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150391_bh, Blocks.field_196661_l, Blocks.field_150424_aL, Blocks.field_150425_aM};
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlaceRandomBlocksStrictly((GolemBase)this, freq, mushrooms, soils, allowed));
    }

    @Override
    public String getModId() {
        return "golems";
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187579_bV;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().func_72935_r() && this.getConfigBool(ALLOW_HEALING) && this.field_70146_Z.nextInt(450) == 0) {
            this.func_195064_c(new PotionEffect(MobEffects.field_76428_l, 50, 1));
        }
    }

    @Override
    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
        byte textureNum = body.func_177230_c() == Blocks.field_150419_aX ? (byte)0 : 1;
        textureNum = (byte)(textureNum % this.getNumTextures());
        this.setTextureNum(textureNum);
    }
}

