/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public final class EntitySlimeGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Extra Knockback";
    public static final String ALLOW_SPLITTING = "Allow Special: Split";
    public static final String KNOCKBACK = "Knockback Factor";

    public EntitySlimeGolem(World world) {
        this(world, false);
    }

    public EntitySlimeGolem(World world, boolean isBaby) {
        super(EntitySlimeGolem.class, world);
        this.setChild(isBaby);
        this.setCanSwim(true);
        this.setLootTableLoc("golem_slime");
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySlimeGolem.makeTexture("golems", "golem_slime");
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (this.getConfigBool(ALLOW_SPECIAL) && !(entity instanceof EntitySlime) && !this.func_70631_g_()) {
                this.knockbackTarget(entity, this.getConfigDouble(KNOCKBACK));
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            super.func_70665_d(source, amount);
            if (!this.func_70631_g_() && source.func_76364_f() != null && this.getConfigBool(ALLOW_SPECIAL)) {
                this.knockbackTarget(source.func_76364_f(), this.getConfigDouble(KNOCKBACK));
            }
        }
    }

    protected void knockbackTarget(Entity entity, double knockbackFactor) {
        double dX = Math.signum(entity.field_70165_t - this.field_70165_t) * knockbackFactor;
        double dZ = Math.signum(entity.field_70161_v - this.field_70161_v) * knockbackFactor;
        entity.func_70024_g(dX, knockbackFactor / 4.0, dZ);
        entity.field_70133_I = true;
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.getConfigBool(ALLOW_SPLITTING)) {
            EntitySlimeGolem slime1 = new EntitySlimeGolem(this.field_70170_p, true);
            EntitySlimeGolem slime2 = new EntitySlimeGolem(this.field_70170_p, true);
            if (this.func_70638_az() != null) {
                slime1.func_70624_b(this.func_70638_az());
                slime2.func_70624_b(this.func_70638_az());
            }
            slime1.func_70012_b(this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, this.field_70177_z + (float)this.field_70146_Z.nextInt(20) - 10.0f, 0.0f);
            slime2.func_70012_b(this.field_70165_t + this.field_70146_Z.nextDouble() - 0.5, this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextDouble() - 0.5, this.field_70177_z + (float)this.field_70146_Z.nextInt(20) - 10.0f, 0.0f);
            this.func_130014_f_().func_72838_d((Entity)slime1);
            this.func_130014_f_().func_72838_d((Entity)slime2);
        }
        super.func_70106_y();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (BABY.equals(key)) {
            if (this.func_70631_g_()) {
                this.func_70105_a(0.7f, 1.45f);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.container.getHealth() / 3.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.container.getAttack() * (double)0.6f);
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.container.getHealth());
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.container.getAttack());
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.35);
            }
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187888_ft;
    }
}

