/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.events.SpongeGolemSoakEvent;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class EntitySpongeGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Absorb Water";
    public static final String INTERVAL = "Water Soaking Frequency";
    public static final String RANGE = "Water Soaking Range";

    public EntitySpongeGolem(World world) {
        super(EntitySpongeGolem.class, world);
        this.setCanSwim(true);
        this.setLootTableLoc("golem_sponge");
    }

    @Override
    protected ResourceLocation applyTexture() {
        return EntitySpongeGolem.makeTexture("golems", "golem_sponge");
    }

    @Override
    public void func_70636_d() {
        int z;
        int y;
        int x;
        BlockPos center;
        SpongeGolemSoakEvent event;
        super.func_70636_d();
        int interval = this.getConfigInt(INTERVAL);
        if (this.getConfigBool(ALLOW_SPECIAL) && this.field_70173_aa % interval == 0 && !MinecraftForge.EVENT_BUS.post((Event)(event = new SpongeGolemSoakEvent(this, center = new BlockPos(x = MathHelper.func_76128_c((double)this.field_70165_t), y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)) + 2, z = MathHelper.func_76128_c((double)this.field_70161_v)), this.getConfigInt(RANGE)))) && event.getResult() != Event.Result.DENY) {
            this.replaceWater(event.getPositionList(), event.getAbsorbFunction(), event.updateFlag);
        }
        if (Math.abs(this.field_70159_w) < 0.05 && Math.abs(this.field_70179_y) < 0.05 && this.field_70170_p.field_72995_K) {
            BasicParticleType particle = this.func_70027_ad() ? Particles.field_197601_L : Particles.field_197606_Q;
            double x2 = this.field_70146_Z.nextDouble() - 0.5 * (double)this.field_70130_N * 0.6;
            double y2 = this.field_70146_Z.nextDouble() * ((double)this.field_70131_O - 0.75);
            double z2 = this.field_70146_Z.nextDouble() - 0.5 * (double)this.field_70130_N;
            this.field_70170_p.func_195594_a((IParticleData)particle, this.field_70165_t + x2, this.field_70163_u + y2, this.field_70161_v + z2, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.field_70146_Z.nextDouble() - 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.5);
        }
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187554_ai;
    }

    public boolean replaceWater(List<BlockPos> positions, Function<IBlockState, IBlockState> replaceWater, int updateFlag) {
        boolean flag = true;
        for (BlockPos p : positions) {
            flag &= this.field_70170_p.func_180501_a(p, replaceWater.apply(this.field_70170_p.func_180495_p(p)), updateFlag);
        }
        return flag;
    }
}

