/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiColorized;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public final class EntityStainedGlassGolem
extends GolemMultiColorized {
    public static final String PREFIX = "stained_glass";
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeTexture("golems", "golem_stained_glass");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeTexture("golems", "golem_stained_glass_grayscale");

    public EntityStainedGlassGolem(World world) {
        super(EntityStainedGlassGolem.class, world, TEXTURE_BASE, TEXTURE_OVERLAY, dyeColorArray);
        this.setCanTakeFallDamage(true);
        this.setLootTableLoc("golem_stained_glass");
    }

    @Override
    public boolean hasTransparency() {
        return true;
    }

    @Override
    public SoundEvent getGolemSound() {
        return SoundEvents.field_187569_bQ;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187561_bM;
    }

    @Override
    public void onBuilt(IBlockState body, IBlockState legs, IBlockState arm1, IBlockState arm2) {
        byte textureNum;
        Block b = body.func_177230_c();
        if (b instanceof BlockStainedGlass) {
            EnumDyeColor color = ((BlockStainedGlass)b).func_196457_d();
            textureNum = (byte)color.func_196059_a();
        } else {
            textureNum = (byte)this.field_70146_Z.nextInt(dyeColorArray.length);
        }
        this.setTextureNum(textureNum);
    }
}

